/* This file is part of the Connector Framework
 * Copyright (C) 2008-2013 Index Data
 * See the file LICENSE for details.
 */

/** \file
 * \brief JSON parser program
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <yaz/xmalloc.h>
#include <yaz/options.h>

#include "json.h"
/** \brief main as usual */
int main(int argc, char **argv)
{
    char *arg = 0;
    int r;
    bool xml_parse = false;
    while ((r=options("x", argv, argc, &arg)) != YAZ_OPTIONS_EOF)
    {
        switch(r)
        {
        case YAZ_OPTIONS_ERROR:
            fprintf(stderr, "Bad option: %s\n", arg);
            exit(1);
        case 'x':
            xml_parse = true;
            break;
        }
    }
    WRBUF w = wrbuf_alloc();
    int c;
    FILE *f = stdin;
    while ((c = getc(f)) != EOF)
        wrbuf_putc(w, c);
    const char *json_str = wrbuf_cstr(w);
    const char *err_msg;

    struct json_node *n = json_parse(json_str, &err_msg);
    if (!n)
    {
        fprintf(stderr, "JSON parse error: %s\n", err_msg);
        json_remove_node(n);
        exit(1);
    }
    wrbuf_rewind(w);
    if (xml_parse)
        json_to_xml(n, w, "opt");
    else
        json_write_wrbuf(n, w);
    json_remove_node(n);
    puts(wrbuf_cstr(w));
    wrbuf_destroy(w);
    exit(0);
}

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */
