#!/bin/bash
# Copyright (c) 2013 IndexData ApS. http://indexdata.com
#
# rewrite-connector.sh - Loads connectors from arguments into engine and rewrites 
#                        back to the same file. Imports template via loadSearchTemplate.js
#
# You should checkout the "cf-repo" git repo on the same top level directory to 
# store the connectors in well indented XML instead a single line.
#
# usage: ./rewrite-connector.sh foo.cf bar.cf ...
#


# Get directory where this script lives. Thanks to:
# http://stackoverflow.com/questions/59895/can-a-bash-script-tell-what-directory-its-stored-in
THIS_PATH="$( cd -P "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"


# Establish base CF path
if test -z "$CF_BASE_PATH"; then
  CF_BASE_PATH="$(cd ${THIS_PATH}/../.. && pwd)"
fi


# Find cfrun binary
CFRUN="./cfrun"

if test ! -x "$CFRUN"; then
  CFRUN=`which cfrun`
fi

if test -z "$CFRUN"; then
  echo "ERROR: cfrun binary not found in path or current directory" >&2
  exit 0
fi


# Find loadSearchTemplate.js script
TMPLJS="$(pwd)/loadSearchTemplate.js"

if test ! -r "$TMPLJS"; then
  TMPLJS="${THIS_PATH}/loadSearchTemplate.js"
fi

if test ! -r "$TMPLJS"; then
  echo "ERROR: loadSearchTemplate.js not found in current directory or directory with this script" >&2
  exit 0
fi


# Set up display
if test "$XVFB"; then
  : ${CF_LOGS_DIR="./logs"}

  if ! which Xvfb >/dev/null; then
    echo "WARNING: Xvfb (Virtual Framebuffer fake X server) not found!"
  fi

  : ${XVFB_SCREEN="-screen 0 800x600x24"}
  echo localhost > ${CF_LOGS_DIR}/Xvfb.hosts
  ( Xvfb :1 $XVFB_SCREEN -auth ${CF_LOGS_DIR}/Xvfb.hosts > ${CF_LOGS_DIR}/Xvfb.out 2>&1 & )
  export DISPLAY=:1.0
fi

if test -z "$DISPLAY"; then
  echo "WARNING: display not set" >&2
fi


# Queue commands and launch cfrun

# Load template
CFRUN_COMMANDS="script ${TMPLJS}\n"

CF_PRETTY_XML=../../../cf-repo/bin/pretty-xml.pl
# Load and save connectors
for connector_path in $@; do
  CFRUN_COMMANDS="${CFRUN_COMMANDS}cf ${connector_path}\n"
  CFRUN_COMMANDS="${CFRUN_COMMANDS}write ${connector_path}\n"
done

CFRUN_COMMANDS="${CFRUN_COMMANDS}quit"


echo -e "${CFRUN_COMMANDS}"

echo -e "${CFRUN_COMMANDS}" | CF_BASE_PATH="${CF_BASE_PATH}" "${CFRUN}"

if [ -f $CF_PRETTY_XML ]; then
  for connector_path in $@; do
    $CF_PRETTY_XML ${connector_path}
  done
else
  echo ""
  echo "Could not find $CF_PRETTY_XML"
  echo "did you checked out 'cf-repo' in the top level directory? e.g.:"
  echo "cd ../../..; git clone ssh://git.indexdata.com:222/home/git/private/cf-repo"
fi

