#!/bin/sh
# Copyright (C) 2010 by Index Data ApS. 
# http://www.indexdata.com
#
# build the engine with the lastest Index Data tools from GIT repo
#
# To install devel tools, see the list of tools on
# http://twiki.indexdata.dk/cgi-bin/twiki/view/ID/CFRepoInstallation


# fail on error
set -e

command=$1

cpu=$(/sbin/sysctl -a 2>/dev/null | egrep kernel.sched_domain.cpu.*.domain0.name | wc -l)
if [ $cpu -le 0 -o $cpu -gt 8 ]; then
    cpu=2
fi

# number of CPUs
: ${ncpu=$cpu}

# test a CF branch
: ${cf_branch=""}

# test a GIT ID on a branch
: ${cf_git_id=""}

# IndexData GIT repository prefix
git_repo=ssh://git.indexdata.com:222/home/git

nice="time nice -n10"
prefix=$(pwd)/opt
make=make

PATH=/bin:/usr/bin; export PATH

# where you installed MacPorts
: ${MACOS_PORTS_PREFIX=/opt/local}

pc=${MACOS_PORTS_PREFIX}/bin/pkg-config

# cross compiling flags for MacOS
case `uname` in
    Darwin ) 	
# xulrunner 1.9 compiles only on i386, not x86. 
# everythings need to be compiled as i386 !!!
            MOZ_VERSION=`$pc --modversion libxul-embedding`
            if [[ $MOZ_VERSION = 2* ]]
            then 
	     	  xulrunner_arch=
            else 
	     	  xulrunner_arch="-arch i386"
            fi
	     	LDFLAGS="$xulrunner_arch -L$MACOS_PORTS_PREFIX/lib"
	     	CFLAGS="$xulrunner_arch -g -O"
	     	CXXFLAGS="$xulrunner_arch -g -O"
	     	PATH="$MACOS_PORTS_PREFIX/bin:$PATH"
		;;

    FreeBSD ) 	make=gmake 
		PATH=$PATH:/usr/local/bin
		LDFLAGS="-L/usr/local/lib"; export LDFLAGS
		;;
    Linux ) 	
	PKG_CONFIG_PATH=/usr/cf-xulrunner/lib/pkgconfig; export PKG_CONFIG_PATH
	if [ -e /etc/redhat-release ]; then
	   centos=`cat /etc/redhat-release `
	   PKG_CONFIG_PATH=/usr/cf-xulrunner/lib64/pkgconfig
	fi
	# outdated autoconf on centos5
	case $centos in 
	    *5.8* ) PATH=/usr/local/bin:$PATH ;;
	esac
	;;	
esac

###################################################


git clone -q $git_repo/private/cf
git clone -q $git_repo/pub/yaz
git clone -q $git_repo/pub/yazpp
git clone -q $git_repo/pub/metaproxy 

dir=`pwd`
if [ -n "$cf_branch" ]; then
   cd "$dir/cf"
   git checkout -b $cf_branch origin/$cf_branch
   if [ -n "$cf_git_id" ]; then
       git checkout $cf_git_id
   fi 
fi

cat <<EOF
LDFLAGS= 	$LDFLAGS
CFLAGS=  	$CFLAGS
CXXFLAGS= 	$CXXFLAGS
PATH=		$PATH
xulrunner_arch= $xulrunner_arch
ncpu=		$ncpu
PKG_CONFIG_PATH=$PKG_CONFIG_PATH

EOF

for software in yaz yazpp metaproxy
do
    echo "build >>> $software <<<"
    cd "$dir/$software"
    $nice ./buildconf.sh 
    LDFLAGS="$LDFLAGS" CFLAGS="$CFLAGS" CXXFLAGS="$CXXFLAGS" $nice ./configure --prefix=$prefix
    $nice $make -j$ncpu INKSCAPE=true all

    if [ $software = "metaproxy" ]; then
	touch doc/multi.png
    fi

    case $command in
    	fullcheck | fulltest ) $make check;;
    esac

    $nice $make INKSCAPE=true install
done


cd "$dir/cf/engine/src"
$nice $make -j$ncpu YAZ_CONFIG=../../../yaz/yaz-config MP_CONFIG=../../../metaproxy/metaproxy-config

case $command in
    test | check | fullcheck | fulltest ) 
	cd "$dir/cf" && $make check ;;
    *) echo "You may run now: $ cd cf; $make check";;
esac

