var EXPORTED_SYMBOLS = ["Mouse"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/waitForLoad.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Mouse = function () {
  this.conf = {};
  this.conf['target'] = ""; // { xpath: "" };
  this.conf['wait'] = {};
  this.conf['wait']['active'] = false;
  this.conf['type'] = "click";
  this.conf['canBubble'] = true;
  this.conf['cancelable'] = true;
  this.conf['detail'] = 0;
  this.conf['screenX'] = 0;
  this.conf['screenY'] = 0;
  this.conf['clientX'] = 0;
  this.conf['clientY'] = 0;
  this.conf['ctrlKey'] = false;
  this.conf['altKey'] = false;
  this.conf['shiftKey'] = false;
  this.conf['metaKey'] = false;
  this.conf['button'] = 0;
};

Mouse.prototype = new Step();
Mouse.prototype.constructor = Mouse;

Mouse.prototype.init = function() {};

Mouse.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  var vbox = xmlHelper.appendNode(surface, "vbox", null, null, null);

  var hbox1 = xmlHelper.appendNode(vbox, "hbox", null, {align:"center"});
  xmlHelper.appendNode(hbox1, "caption", "Target element xpath: ", null, null);
  xulHelper.singleNodeField(hbox1, this, 'target');

  var hbox2 = xmlHelper.appendNode(vbox, "hbox", null, {align:"center"});
  xmlHelper.appendNode(hbox2, "caption", "Mouse event type: ", null, null);
  xulHelper.arraySelectField(hbox2, this, 'type', 
    ["click", "dblclick", "mousedown", "mouseup", "mouseover", "mousemove", "mouseout"]);
  xmlHelper.appendNode(hbox2, "caption", "Mouse button: ", null, null);
  xulHelper.arraySelectField(hbox2, this, 'button',
    {"left":0, "right":1, "middle":2});

  var hbox3 = xmlHelper.appendNode(vbox, "hbox", null, {align:"center"});
  xulHelper.inputField(hbox3, this, 'screenX', "Screen X: ", '70', {'width':'40'});
  xulHelper.inputField(hbox3, this, 'screenY', "Screen Y: ", '70', {'width':'40'});
  xulHelper.inputField(hbox3, this, 'clientX', "Client X: ", '70', {'width':'40'});
  xulHelper.inputField(hbox3, this, 'clientY', "Client Y: ", '70', {'width':'40'});
  xulHelper.inputField(hbox3, this, 'detail', "Detail: ", '70', {'width':'40'});

  var hbox4 = xmlHelper.appendNode(vbox, "hbox", null, {align:"center"});
  xulHelper.checkbox(hbox4, this, 'ctrlKey', "ctrl");
  xulHelper.checkbox(hbox4, this, 'altKey', "alt");
  xulHelper.checkbox(hbox4, this, 'shiftKey', "shift");
  xulHelper.checkbox(hbox4, this, 'metaKey', "meta");
  xulHelper.checkbox(hbox4, this, 'canBubble', "Can bubble?");
  xulHelper.checkbox(hbox4, this, 'cancelable', "Cancelable?");

  waitForLoad.stepXul(surface, this.conf['wait']);
};

Mouse.prototype.run = function (task) {
  this.task.connector.clearPageOverride();
  waitForLoad.wait(task, this.conf.wait);  
  var pageDoc = this.getPageDoc();
  var pageWin = this.getPageWindow();
  var target = xmlHelper.getElementByNodeSpec(pageDoc, this.conf['target']);
  let nodeSpec = jsonPathHelper.inlineReplaceNodeSpec(this.conf.target, task.data);
  let target = xmlHelper.getElementByNodeSpec(pageDoc, nodeSpec);
  if (target === null) {
    throw new StepError("Target element not found.");
  }
  var mouseEvent = pageDoc.createEvent("MouseEvents");
  mouseEvent.initMouseEvent(
    this.conf['type'],
    this.conf['canBubble'],
    this.conf['cancelable'],
    pageDoc.defaultView,
    this.conf['detail'],
    this.conf['screenX'],
    this.conf['screenY'],
    this.conf['clientX'],
    this.conf['clientY'],
    this.conf['ctrlKey'],
    this.conf['altKey'],
    this.conf['shiftKey'],
    this.conf['metaKey'],
    this.conf['button'],
    null);

  task.info("sending " + this.conf['type'] + " event to " +
    this.conf.target.xpath, this);
  var start = new Date().getTime();
  var ret = target.dispatchEvent(mouseEvent);
  if (!ret) task.warn("Dispatched event may have been prevented.");
};

Mouse.prototype.getClassName = function () {
  return "Mouse";
};

Mouse.prototype.getDisplayName = function () {
  return "Mouse";
};
Mouse.prototype.getDescription = function () {
  return "Sends a mouse event to an element.";
};
Mouse.prototype.getVersion = function () {
  return "1.0";
};

Mouse.prototype.upgrade = function (confVer, curVer, conf) { 
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.2) {
    var oldwait = conf['wait'];
    conf['wait'] = {};
    conf['wait']['active'] = oldwait;
  }
  return true;
};

Mouse.prototype.renderArgs = function () {
  return this.conf.type + "->" + (this.conf.target.xpath?this.conf.target.xpath:"");
}

Mouse.prototype.isDeprecated = function () {
  return true;
};

Mouse.prototype.getDeprecationInfo = function () {
  return "Superceded by the Event step";
}
