#ifndef __EmbeddingSetup_h_
#define __EmbeddingSetup_h_

#include "cf_logger.h"

#include "nscore.h"

/**
 * Initializes embedding, i.e. loads needed libs do other needed setup.
 *
 * You can call this as many times you like,
 * it will only do the initialization once,
 * but be sure to call TermEmbedding a matching number of times.
 *
 * @param aProfilePath Optional argument to set the path where
 *  profile data is stored. The directory will be created if it
 *  doesn't exist.
 */
nsresult InitEmbedding(const char* aProfilePath, const char *mozembedDir,
                       CF_Logger *logger);

/**
 * Terminates embedding, i.e. does teardown and unloads needed libs.
 *
 * Make sure to match every call of InitEmbedding with a call
 * to TermEmbedding. Only the last call to TermEmbedding will do
 * the actual termination.
 */
nsresult TermEmbedding(CF_Logger *logger);

#endif // __EmbeddingSetup_h_
/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */
