var EXPORTED_SYMBOLS = ["Extract"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import("resource://indexdata/runtime/core.js");
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');
var logger = logging.getLogger();
var Extract = function () {
  this.className = "Extract";
  this.truncate = 80;
  this.conf = {};
  this.conf["node"] = "";
  this.conf["sourceAttribute"] = "";
  this.conf["attributes"] = [];
  this.conf["jsonPath"] = "";
  this.conf["failNone"] = true;
  this.conf["failMulti"] = false;
  this.conf["resultType"] = 9;
};
Extract.prototype = new Step();
Extract.prototype.constructor = Extract;
Extract.prototype.init = function() {  };
Extract.prototype.drawRadios = function(attributes, values, div, checked) {
  let htmlns = "http://www.w3.org/1999/xhtml";
  let doc = div.ownerDocument;
  xmlHelper.emptyChildren(div);
  let a = {};
  a.type = "radio";
  a.name = "attr";
  a.value = "textContent";
  if (a.value === checked) a.checked = true;
  let text = doc.createTextNode(" text" + (values ? values[0] : ""));
  xmlHelper.appendNode(div, "input", null, a, htmlns);
  div.appendChild(text);
  xmlHelper.appendNode(div, "br", null, null, htmlns);
  for (let i = 0; i < attributes.length; i++) {
    let a = {};
    a.type = "radio";
    a.name = "attr";
    a.value = attributes[i];
    if (a.value === checked) a.checked = true;
    let text = doc.createTextNode(" " + attributes[i] + (values ? values[i+1] : ""));
    xmlHelper.appendNode(div, "input", null, a, htmlns);
    div.appendChild(text);
    xmlHelper.appendNode(div, "br", null, null, htmlns);
  }
}
Extract.prototype.draw = function(surface) {
  var context = this;
  var htmlns = "http://www.w3.org/1999/xhtml";
  var attrRadioDiv = {};
  logger.debug("Extract.draw: Starting");
  var advancedCaption = "Advanced";
  logger.debug("Extract.draw: Starting type " + this.conf.resultType);
  if (!(this.conf.resultType === 9)) advancedCaption += " *";
  var tabs = xulHelper.tabBox(surface, [ "Basic", advancedCaption ],
    { flex: 1 });
  var basicTab = xmlHelper.appendNode(tabs[0], "vbox", null,
    {flex: 1, pack:"start"});
  var advancedTab = xmlHelper.appendNode(tabs[1], "vbox", null,
    {flex: 1, pack:"start"});

  // New node, we can populate attrRadioDiv with attributes and values
  var onNodeSelect = function(node) {
    //logger.debug("Extract.draw.onNodeSelect: node=" + node );
    if (!node) {
      logger.debug("Extract.draw.onNodeSelect: No node, can not make attribute list");
      return; // This can happen if the user edits the XPath by hand
    }
    if ( node && node.cf_datanode ) node = node.cf_datanode;
    // Default to text content
    context.conf["sourceAttribute"] = "textContent";
    var attributes = [];
    var values = [" = " + node.textContent.substring(0, context.truncate)];
    for (let i = 0; i < node.attributes.length; i++) {
      let attribute = node.attributes.item(i);
      if ( attribute.name.indexOf("cf_")!=0) { // skip highlight temp attrs
        attributes.push(attribute.name);
        values.push(" = " + node.attributes.item(i).value.substring(0, context.truncate));
      }
      //logger.debug("Extract.draw.onNodeSelect: " + i + ": " +
      //    node.attributes.item(i).value.substring(0, context.truncate)  );
    }
    // TODO: Add an option to get the inner html/xml of the node
    context.conf.attributes = attributes;
    context.drawRadios(attributes, values, attrRadioDiv, "textContent");
  };

  //// Basic Configuration
  // XPath field
  let hbox = xmlHelper.appendNode(basicTab, "hbox", null, {align: "center"}, null);
  xmlHelper.appendNode(hbox, "caption", "Source element: ", null, null);
  var input = xulHelper.singleNodeField(hbox, this, "node", onNodeSelect);
  xulHelper.checkbox(basicTab, this, "failNone", "Fail if no nodes match");
  // JSONPath field
  xulHelper.jsonPathField(basicTab, this, this.conf, "jsonPath", "Container: ",
    {path:"$.output", key:"hits", append:jsonPathHelper.REPLACE});
  // Attributes
  xmlHelper.appendNode(basicTab, "caption", null, {label:"Attributes: "});
  var form = xmlHelper.appendNode(basicTab, "form", null,
    {name:"cf_extra_radios"}, htmlns);
  var attrRadioDiv = xmlHelper.appendNode(form, "div", null,
    {style:"-moz-column-width: 20em; valign: top"}, htmlns);
  // Stored node, values are likely different now and who knows what
  // page it came from, but attribute names were saved for posterity.
  if (this.conf.node && this.conf.attributes) {
    this.drawRadios(this.conf.attributes, null, attrRadioDiv,
                    this.conf.sourceAttribute);
  }
  attrRadioDiv.addEventListener("change", function(e) {
    context.conf["sourceAttribute"] = e.target.value;
  }, false);
  input.addEventListener("change", function(e) {
    // Refresh display of attributes when the XPath is edited by hand
    // provided there is no inline replacement going on
    // ### Why can't we just run tghe substitution? We need some attrs in the list! -H
    if (input.value.indexOf("{$") == -1) {
      onNodeSelect(xmlHelper.getElementByXpath(context.getPageDoc(), input.value));
    }
  }, false);
  xmlHelper.appendNode(basicTab, "spacer", null, {flex: 1}, null);

  //// Advanced Configuration
  var c = {};
  var conf = this.conf;
  c.order = xmlHelper.appendNode(advancedTab, "checkbox", null,
    {label: "Follow document order"});
  c.multi = xmlHelper.appendNode(advancedTab, "checkbox", null,
    {label: "Extract from multiple nodes"});
  c.failMulti = xmlHelper.appendNode(advancedTab, "checkbox", null,
    {label: "Fail if more than one match on multiple extract)"});
  c.noSnap = xmlHelper.appendNode(advancedTab, "checkbox", null,
    {label: "Don't use snapshot for multiple nodes"});
  c.any = xmlHelper.appendNode(advancedTab, "checkbox", null,
    {label: "Any: Scalar results from functions and multiple unordered nodes"});
  var fromChecks = function () {
    if (c.failMulti.checked) conf.failMulti = true;
    else conf.failMulti = false;
    if (c.any.checked) conf.resultType = 0;
    else {
      if (c.noSnap.checked) conf.resultType = c.order.checked ? 5 : 4;
      else {
        if (c.multi.checked) conf.resultType = c.order.checked ? 7 : 6;
        else conf.resultType = c.order.checked ? 9 : 8;
      }
    }
    logger.debug("Extract: setting resultType = " + conf.resultType
      + ", failMulti = " + conf.failMulti);
  }
  var toChecks = function () {
    let rt = conf.resultType
    for (let x in c) { c[x].disabled = false };
    for (let x in c) { c[x].checked = false };
    if (conf.failMulti) {
      c.failMulti.checked = true;
      c.multi.checked = true;
      c.multi.disabled = true; 
    }
    switch (rt) {
    case 0: // ANY_TYPE
      c.multi.checked = true;
      c.multi.disabled = true; 
      c.noSnap.checked = true;
      c.noSnap.disabled = true;
      c.order.checked = false;
      c.order.disabled = true;
      c.any.checked = true;
      return;
    case 4: // UNORDERED_NODE_ITERATOR_TYPE
    case 5: // ORDERED_NODE_ITERATOR_TYPE
      c.noSnap.checked = true;
    case 6:
    case 7:  
      c.multi.checked = true;
      break;
    }
    if (rt === 5 || rt === 7 || rt === 9) c.order.checked = true;
  }
  for (let x in c) {
    c[x].addEventListener("command", function(e) {
      fromChecks();
      toChecks(); // variously disable things as necessary
    }, false);
  }
  toChecks();
};

Extract.prototype.run = function (task) {
  var doc = this.getPageDoc();
  if (core.inBuilder) xulHelper.unhighlightAll(doc, true);
  var conf = this.conf;
  var sourceAttr = conf.sourceAttribute
  if (!sourceAttr) sourceAttr = "textContent";
  var nodeSpec = jsonPathHelper.inlineReplaceNodeSpec(conf.node, task.data);
  xmlHelper.checkNodeSpec(nodeSpec);
  var result = xmlHelper.evaluateNodeSpec(doc, nodeSpec, conf.resultType);
  var extracted = [];
  var extractValue = function (node, nohl) {
    if (node === null) return; // no match
    if (sourceAttr === "textContent") var value = node.textContent;
    else var value = node.getAttribute(sourceAttr);
    if (value !== null) extracted.push(value);
    // If in builder, highlight match. Can't highlight if we're
    // using a non-snapshot iterator though as mutating the DOM
    // invalidates the iterator.
    if (core.inBuilder && !nohl) xulHelper.highlightNode(node, "yellow", true);
  }
  switch (result.resultType) {
  case 1: // NUMBER_TYPE
    extracted = [""+result.numberValue];  // coerce to string
    break;
  case 2: // STRING_TYPE
    extracted = [result.stringValue];
    break;
  case 3: // BOOLEAN_TYPE
    extracted = [""+result.booleanValue]; // coerce to string
    break;
  case 4: // UNORDERED_NODE_ITERATOR_TYPE
  case 5: // ORDERED_NODE_ITERATOR_TYPE
    var cur = result.iterateNext();
    while (cur) {
      extractValue(cur, true); // true disables highlight -^
      cur = result.iterateNext();
    }
    break;
  case 6: // UNORDERED_NODE_SNAPSHOT_TYPE
  case 7: // ORDERED_NODE_SNAPSHOT_TYPE
    var len = result.snapshotLength;
    if (len > 1 && conf.failMulti) {
      throw new StepError("Failing on multiple matches to "
        + JSON.stringify(nodeSpec));
    }
    for (var i = 0; i < len; i++) { extractValue(result.snapshotItem(i)); }
    break;
  case 8: // ANY_UNORDERED_NODE_TYPE
  case 9: // FIRST_ORDERED_NODE_TYPE
    extractValue(result.singleNodeValue);
    break;
  default:
    throw new StepError("Unexpected result type " + result.resultType
      + " extracting all from " + JSON.stringify(nodeSpec));
  }
  if (extracted.length > 0) {
    if (extracted.length > 1 && conf.failMulti) {
      throw new StepError("Failing on multiple matches to "
        + JSON.stringify(nodeSpec));
    }
    jsonPathHelper.set(conf.jsonPath, extracted, task.data);
  } else if (conf.failNone) {
      throw new StepError("No match to "
        + JSON.stringify(nodeSpec));
  }
};
Extract.prototype.getClassName = function () { return "Extract"; };
Extract.prototype.getDisplayName = function () { return "Extract value"; };
Extract.prototype.getDescription = function () {
  return "Populates a result with text from an element text or attribute.";
};
Extract.prototype.getVersion = function () { return "4.0"; };
Extract.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer) return false;
  if (confVer < 4.0) {
    if (conf.extractAll) {
      conf.failNone = false;
      conf.failMulti = false;
      conf.resultType = 0;
    } else {
      conf.failNone = true;
      conf.failMulti = false;
      conf.resultType = 9;
    }
    delete conf.extractAll;
  }
  if (confVer < 0.3) {
    conf.jsonPath = jsonPathHelper.specFromArray(["output", conf.result]);
    delete conf.result;
  }
  return true;
};
Extract.prototype.renderArgs = function () {
  if (!this.conf.node.xpath) return "";
  return this.conf.node.xpath;
}
