var EXPORTED_SYMBOLS = ["DataBrowser"];
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');
Components.utils.import("resource://indexdata/ui/app.js");
Components.utils.import("resource://indexdata/ui/taskPane.js");
Components.utils.import("resource://indexdata/ui/testEditor.js");
Components.utils.import("resource://indexdata/runtime/Task.js");
var logger = logging.getLogger();
// abbreviation
var child = xmlHelper.appendNode;
// constructor
var DataBrowser = function () {};
DataBrowser.prototype.init = function (tabBox, contextMenu) {
  this.tabBox = tabBox;
  this.contextMenu = contextMenu;
  this.dataTab = 1;
};
DataBrowser.prototype.setTask = function (task) {
  this.task = task;
};
DataBrowser.prototype.refresh = function () {
  let context = this;
  let task = this.task;
  if (this.task) {
    let keys = Task.dataKeys.concat(Task.connectorDataKeys);
    let tabBox = this.tabBox;
    xmlHelper.emptyChildren(tabBox);
    let tabs = xmlHelper.appendNode(tabBox, "tabs");
    for (let i = 0; i < keys.length; i++) {
      let tab = xmlHelper.appendNode(tabs, "tab", null, {label: keys[i]});
    }
    let panels = xmlHelper.appendNode(tabBox, "tabpanels", null, { flex: 1, style: 'padding: 0; margin: 0;'  });
    for (let i = 0; i < keys.length; i++) {
      let panel = xmlHelper.appendNode(panels, "tabpanel", null, { flex: 1, style: 'padding: 0; margin: 0;' });
      let tree = xmlHelper.appendNode(panel, "tree", null, {
        flex: 1,
        value: keys[i],
        hidecolumnpicker: 'true',
        style: 'padding: 0; margin: 0;'
      });
      // couldn't get the context attribute to work, seems like all this is still necessary
      tree.addEventListener("contextmenu", function (e) {
        context.onDataTreeClick(e);
      }, false);
      let treecols = xmlHelper.appendNode(tree, "treecols");
      xmlHelper.appendNode(treecols, "treecol", null, {ordinal: 1, label: "Name", flex: 1, primary: true});
      xmlHelper.appendNode(treecols, "splitter", null, {ordinal: 2, class: "tree-splitter"});
      xmlHelper.appendNode(treecols, "treecol", null, {ordinal: 3, label: "Value", flex: 3});
      let treechildren = xmlHelper.appendNode(tree, "treechildren", null, { flex: 1 });
      this.addDataNodes(treechildren, task.data[keys[i]], "");
    }
    tabBox.selectedIndex = this.dataTab;
  } else logger.debug("Data browser has no task."); 
};
DataBrowser.prototype.clearData = function () {
  this.task.clearData();
  this.refresh();
};
DataBrowser.prototype.clearCurrent = function () {
  delete this.task.data[this.tabBox.selectedTab.label];
  this.refresh();
};
DataBrowser.prototype.editData = function () {
  var context = this;
  app.newJsonEditWindow(
    this.task.data,
    function (obj) {
      context.task.rebuildData(obj);
      context.refresh();
    },
    'editData'
  );
};
DataBrowser.prototype.addDataNodes = function (root, obj, parentPath, parentName) {
  for (let key in obj) {
    // TODO: generate JSONpath here
    var jsPath = parentPath + "/" + key;
    var item = xmlHelper.appendNode(root, "treeitem", null, {"assertpath": jsPath});
    var row = xmlHelper.appendNode(item, "treerow");
    var dispkey = key;
    if ( parentName && ! parentName.match( /^[0-9]+/ ) )
      dispkey = parentName + " [" + key + "]";
    if ( typeof(obj[key]) == "object" && obj[key].length > 1 ) {
      dispkey = key + " (" + obj[key].length + ")";
    }
    //xmlHelper.appendNode(row, "treecell", null, {"label": key });
    xmlHelper.appendNode(row, "treecell", null, {"label": dispkey });
    if (typeof obj[key] != "object") {
      xmlHelper.appendNode(row, "treecell", null, {"label": obj[key]});
      item.setAttribute("tooltiptext", obj[key]);
      item.setAttribute("cfvalue", obj[key]);
    } else if ((obj[key].length == 1) && (typeof obj[key][0] != "object")) {
      xmlHelper.appendNode(row, "treecell", null, {"label": obj[key][0]});
      item.setAttribute("tooltiptext", obj[key][0]);
      item.setAttribute("cfvalue", obj[key][0]);
    } else {
      item.setAttribute("container", "true");
      item.setAttribute("open", "true");
      item.setAttribute("cfvalue", JSON.stringify(obj[key]));
      var crib = xmlHelper.appendNode(item, "treechildren");
      if (obj[key].length == 1) {
        this.addDataNodes(crib, obj[key][0], jsPath, "");
      } else {
        this.addDataNodes(crib, obj[key], jsPath, key);
      }
    }
  }
};
DataBrowser.prototype.onDataTreeClick = function (e) {
  var tree =  e.currentTarget;
  var treeBox = tree.treeBoxObject;
  var row = {}, col = {}, obj = {};
  // row.value has the row index
  // col.value has the column object
  treeBox.getCellAt(e.clientX, e.clientY, row, col, obj);
  // row out of bound
  if (row.value == -1) return;
  // go only for the 'value' column
  //if (col.value.element.getAttribute("label") == "Name") return;
  var treeItem = tree.contentView.getItemAtIndex(row.value);
  var assertPath = treeItem.getAttribute("assertpath");
  testEditor.lastAssertPath = assertPath;
  this.contextMenu.openPopup(treeItem, "after_pointer", e.clientX, e.clientY, true);
  logger.debug("Tree clicked at address " + assertPath + ". ("
               +e.clientX+","+e.clientY+")");
};
DataBrowser.prototype.copyData = function(menuitem) {
  let treeitem = menuitem.parentNode.anchorNode;
  if (treeitem.hasAttribute("cfvalue")) {
    const gClipboardHelper = Components.classes["@mozilla.org/widget/clipboardhelper;1"].
    getService(Components.interfaces.nsIClipboardHelper);
    gClipboardHelper.copyString(treeitem.getAttribute("cfvalue"));
  }
};
DataBrowser.prototype.openAsURL = function(menuitem) {
  let treeitem = menuitem.parentNode.anchorNode;
  if (treeitem.hasAttribute("cfvalue")) {
    app.mainWindow.gBrowser.addTab(treeitem.getAttribute("cfvalue"));
  }
};

