var EXPORTED_SYMBOLS = ["htmlHelper"];
Components.utils.import("resource://indexdata/runtime/core.js");
Components.utils.import('resource://indexdata/util/logging.js');
var logger = logging.getLogger();

var htmlHelper = {
  collectFrames: function (doc) {
    if (doc === null) throw new Error("The 'doc' object must not be null");
    var frameNodes = [];
    var docFrames = doc.getElementsByTagName("frame");
    var docIframes = doc.getElementsByTagName("iframe");
    for (var i=0; i<docFrames.length; i++) {
      var f = docFrames.item(i).contentDocument;
      if (f !== null)
        frameNodes.push(f);
    }
    for (var i=0; i<docIframes.length; i++) {
      var f = docIframes.item(i).contentDocument;
      if (f !== null)
        frameNodes.push(f);
    }
    var childFrames = [];
    for (var i=0; i<frameNodes.length; i++) {
      childFrames = childFrames.concat(
        htmlHelper.collectFrames(frameNodes[i]));
    }
    return frameNodes.concat(childFrames);
  },

  escapeHTML: function (str) {
    return str.replace(/[&"<>]/g,
      function (m) "&" + ({ "&": "amp", '"': "quot", "<": "lt", ">": "gt" })[m] + ";");
  },


  // Produce a HTML rendering of an XML document or fragment
  // Create cross-links between the HTML and XML, so we can later
  // use those to match nodes on screen to nodes in XML, for example
  // for highlighting.
  renderXml: function ( xml, doc, docnode) {
    if (core.inBuilder) {
      htmlHelper._renderXml_recursive( xml, doc, docnode, 0);
      // cross-link the documents for highlighting
      xml.cf_displaydoc = doc;
      doc.cf_datadoc = xml;
    }
  },

  // TODO - Make a helper that determines if a node is a short-node.
  // That is, a regular node that has no attributes and exactly one
  // child which is a #text node with sufficiently short content.
  // Then use that helper to render such nodes on one line, like
  //   <PubYear>1987</PubYear>
  // instead of the usual 3-line layout. Will make display much more
  // readable.

  _renderXml_recursive: function ( xml, doc, docnode, indent) {
    while(xml) {
      var ind = "";
      for ( var i=0; i<indent; i++)
        ind += "&nbsp;&nbsp;&nbsp;&nbsp;";
      var div = htmlHelper._renderXmlNode( xml, doc, docnode, ind, true);
      if (div) {
        xml.cf_displaynode = div;
        docnode.appendChild(div);
      }
      if ( xml.firstChild ) { // render children, and a closing tag
        htmlHelper._renderXml_recursive( xml.firstChild, doc, div, indent+1);
        var div2 = htmlHelper._renderXmlNode( xml, doc, docnode, ind, false);
        if (div2) {
          //docnode.appendChild(div2);
          div.appendChild(div2);
        }
      }
      xml = xml.nextSibling;
    }
  },

  // Helper to render one XML node, either its start or end tag
  _renderXmlNode: function ( xml, doc, docnode, ind, starttag ) {
    var div = doc.createElement("div");
    div.cf_datanode = xml;
    if ( xml.nodeName == "#document" ) {
      return div; // Need to return something
    }
    if ( xml.nodeName == "#comment" ) {
      if (starttag) {
        var txt = xml.nodeValue;
        div.innerHTML = ind + "&lt;!--" + txt + "--&gt;" + "<br/>\n";
        div.style.color = "green";
        return div;
      } else
        return false; // no need for end tags
    }
    if ( xml.nodeName == "#text" ) {
      if (starttag) {
        var txt = xml.nodeValue;
        if (txt.match( /^\s*$/) )
          return false; // only whitespace, don't bother
        div.innerHTML = ind + txt + "<br/>\n";
        div.style.color = "black";
        div.cf_datanode = xml.parentNode; // point to the tag around text
        return div;
      } else
        return false;
    }
    if ( xml.nodeName == "#cdata-section" ) {
      if (starttag) {
        var txt = xml.nodeValue;
        if (txt.match( /^\s*$/) )
          return false; // only whitespace, don't bother
        div.innerHTML = ind + "&lt;![CDATA[" + txt + "]]<br/>\n";
        div.style.color = "brown";
        div.cf_datanode = xml.parentNode; // point to the tag around text
        return div;
      } else
        return false;
    }
    // default to regular node
    var attrstr = "";
    if ( starttag ) {
      if ( xml.hasAttributes() ) {
        attrstr = " ";
        var attrs = xml.attributes;
        for ( var i=0; i < attrs.length; i++ ) {
          var n = attrs[i].nodeName;
          var v = attrs[i].nodeValue;
          attrstr += "" +  n + "=\"" + v + "\" ";
        }
      }
      var endslash = "";
      if ( ! xml.firstChild )
        endslash = "/";
      div.innerHTML = ind + "&lt;" + xml.nodeName + attrstr +
        endslash + "&gt;" + "<br/>\n";
    } else {
      div.innerHTML = ind + "&lt;" + "/" + xml.nodeName + "&gt;" + "<br/>\n";
    }
    div.style.color = "blue";
    return div;
  }
}
