Components.utils.import("resource://gre/modules/XPCOMUtils.jsm");
const Ci = Components.interfaces;
const nsIContentPolicy = Ci.nsIContentPolicy;

const ACCEPT = nsIContentPolicy.ACCEPT;
const REJECT_TYPE = nsIContentPolicy.REJECT_TYPE;
const REJECT_REQUEST = nsIContentPolicy.REJECT_REQUEST;

function ContentFilter() {
  this.wrappedJSObject = this;
}

ContentFilter.prototype = {
  // Used by XPCOMUtils to generate factory, &tc.
  classDescription: "Content filter implementing the nsiContentPolicy interface.",
  classID: Components.ID("{09c1fff9-e968-493d-b907-11343525c099}"),
  contractID: "@indexdata.com/contentfilter;1",

  // I have no idea why but apparently everything needs to be an observer now?
  QueryInterface: XPCOMUtils.generateQI([Ci.nsISupports, Ci.nsIContentFilter, Ci.nsIContentPolicy, Ci.nsIObserver]),
  observe: function(subject, topic, data) {},

  blacklist: [],
  whitelist: [],
  blockCss: false,
  blockImages: true,
  blockObjects: true,



  // for nsIContentPolicy
  shouldLoad: function (contentType, contentLocation, requestOrigin, context, mimeTypeGuess, extra)  {
    if (contentLocation.scheme==="http" || contentLocation.scheme==="https") {
//       // OFFSITE REJECTED: http://query.nytimes.com/search/alternate/ from file:///home/jason/id/git/cf/engine/src/page.html
//       if (contentLocation.host.split(".").slice(-2).join(".") != requestOrigin.host.split(".").slice(-2).join("."))
//         dump ("OFFSITE REJECTED: " + contentLocation.spec + " from " + requestOrigin.spec + "\n");
//         return REJECT_REQUEST;

      switch (contentType) {
        case nsIContentPolicy.TYPE_IMAGE:
          if (this.blockImages) {
//             dump ("IMAGE REJECTED: " + contentLocation.spec + "\n");
            return REJECT_TYPE;
          }
          break;
        case nsIContentPolicy.TYPE_STYLESHEET:
          if (this.blockCss) {
//             dump ("CSS REJECTED: " + contentLocation.spec + "\n");
            return REJECT_TYPE;
          }
          break;
        // TYPE_OBJECT is typically returned for plugin content ie. Flash, Java
        case nsIContentPolicy.TYPE_OBJECT:
          if (this.blockObjects) {
//             dump ("OBJECT REJECTED: " + contentLocation.spec + "\n");
            return REJECT_TYPE;
          }
          break;
        case nsIContentPolicy.TYPE_OTHER:
          if (this.blockObjects) {
            dump ("OTHER REJECTED: " + contentLocation.spec + "\n");
            return REJECT_TYPE;
          }
          break;
        case nsIContentPolicy.TYPE_OBJECT_SUBREQUEST:
          if (this.blockObjects) {
            dump ("OBJECT_SUBREQUEST REJECTED: " + contentLocation.spec + "\n");
            return REJECT_TYPE;
          }
          break;
        case nsIContentPolicy.TYPE_FONT:
          if (this.blockObjects) {
            dump ("FONT REJECTED: " + contentLocation.spec + "\n");
            return REJECT_TYPE;
          }
          break;
        case nsIContentPolicy.TYPE_MEDIA:
          if (this.blockObjects) {
            dump ("MEDIA REJECTED: " + contentLocation.spec + "\n");
            return REJECT_TYPE;
          }
          break;
      }

      for (var i=0; i<this.whitelist.length; i++) {
        var re = new RegExp(this.whitelist[i]);
        if (re.test(contentLocation.spec)) {
//           dump ("WHITELISTED: " + contentLocation.spec + "\n");
          return ACCEPT;
        }
      }

      for (var i=0; i<this.blacklist.length; i++) {
        var re = new RegExp(this.blacklist[i]);
        if (re.test(contentLocation.spec)) {
          dump ("BLACKLISTED: " + contentLocation.spec + "\n");
          return REJECT_REQUEST;
        }
      }

//       dump ("HTTP ACCEPTED: " + contentLocation.spec + "\n");
    }
    return ACCEPT;
  },

  shouldProcess: function (contentType, contentLocation, requestOrigin, context, mimeType, extra)  {
    // this is for deciding what to do with things after fetching them
    return ACCEPT;
  },



  // for nsIContentFilter
  addBlacklist: function (re) {
   this.blacklist.push(re);
  },

  resetBlacklist: function () {
    this.blacklist = [];
  },

  addWhitelist: function (re)  {
    this.whitelist.push(re);
  },

  resetWhitelist: function ()  {
    this.whitelist = [];
  },

  setBlockCss: function (block) {
    if (block===true)
      this.blockCss=true;
    else
      this.blockCss=false;
  },

  setBlockImages: function (block) {
    if (block===true)
      this.blockImages=true;
    else
      this.blockImages=false;
  },

  setBlockObjects: function (block) {
    if (block===true)
      this.blockObjects=true;
    else
      this.blockObjects=false;
  },
};

// Factory
var components = [ContentFilter];
if (XPCOMUtils.generateNSGetFactory)
  var NSGetFactory = XPCOMUtils.generateNSGetFactory(components);
else
  var NSGetModule = XPCOMUtils.generateNSGetModule(components);

