var EXPORTED_SYMBOLS = ["TaskTemplate"];
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/objHelper.js');
var TaskTemplate = function () {
  this.properties = {};
  this.args = [];
  this.name = "";
  this.description = "";
  this.testNodes = []; //raw 'proto' test nodes contained within the task tmpl
};
TaskTemplate.prototype = {
  //load template from XML
  load: function (ttNode) {
    this.fullqueryDefaults= {};  // e.g. { 'cql': fields { title: "ti=", etc }, etc }
    this.name = ttNode.getAttribute("name");
    this.description = ttNode.getAttribute("description") || "";
    this.properties = objHelper.loadProperties(ttNode);
    this.defaults = objHelper.loadDefaults(ttNode);
    // args
    if (this.properties.data !== undefined &&
        this.properties.data.input !== undefined) {
      let inputTmpl = this.properties.data.input;
      for (let key in inputTmpl) {
        this.args.push(key);
      }
    }
    //call me lazy, but I don't feel like building yet another tree struct
    //and re-implementing what test.loadConf already does
    //if that leaks mem in any way will just clone it
    this.testNodes = ttNode.getElementsByTagName('test');
    // fullqueryDefaults
    var defnodes = ttNode.getElementsByTagName('fullqueryDefault');
    for ( var j=0; j<defnodes.length; j++) {
        var defnode = defnodes[j];
        var name = defnode.getAttribute('name');
        var defset = objHelper.objectFromXml(defnode);
        this.fullqueryDefaults[name] = defset;
    }
  },

  getName: function () { return this.name; },
  getDescription: function () { return this.description; },
  getArgNames: function () { return this.args; },
  getFullqueryDefaults: function () { return this.fullqueryDefaults; },
};
