var EXPORTED_SYMBOLS = ["Httpclient"];

// A step that can be a HTTP client for various web services
// Especially a SOAP client to Elsevier's search service, and
// hopefully others as well.


Components.utils.import('resource://indexdata/runtime/Task.js');
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/textHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/htmlHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');
Components.utils.import('resource://indexdata/thirdparty/jsonPath.js');
Components.utils.import("resource://indexdata/runtime/core.js");


var logger = logging.getLogger();

// TODO
// Move the URL into its own tab. Add lines to add parameters, so as to make
// it easier to build it. or maybe not, transforms should be fine

var Httpclient = function () {
  this.className = "Httpclient";
  this.conf = {};
  this.conf['type'] = "";
  //this.conf['request'] = "";
  this.conf['url'] = "";  // constant url
  this.conf['urljp'] = ""; // variable to take url from
  this.conf['reqjp'] = ""; // variable to take the request from
};

Httpclient.prototype = new Step();
Httpclient.prototype.constructor = Httpclient;
Httpclient.prototype.init = function() {};

const types = { "POST": "POST (soap)",
                "GET": "GET" };
// More to be added in some later version

const xmlheader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
const soapEnvelope = xmlheader +
  "<soap:Envelope xmlns=\"http://www.w3.org/2001/12/soap-envelope\" >\n" +
  "  <Header> \n" +
  "  </Header> \n" +
  "  <Body> \n" +
  "  </Body> \n" +
  "</Envelope> \n" ;

//////////////////
// Draw
Httpclient.prototype.draw = function(surface,win) {

  var tabs = xulHelper.tabBox( surface,
          [ "General", "Request" ],
          { flex: 1 } );
  this.drawGeneralTab( tabs[0], this, tabs);
  this.drawRequestTab( tabs[1], this, tabs);

};

Httpclient.prototype.drawGeneralTab = function (surface, context, tabs) {
  var vb = xmlHelper.appendNode(surface, "vbox", null,
           {"flex":1,"align":"stretch"} );

  var typesel = xulHelper.selectField(vb, context, "type",
            "Service type", types, {} );

  var urlradiogroup = xmlHelper.appendNode(vb, "radiogroup");
  xulHelper.captionField(urlradiogroup, "URL of the service");
  var urbox1 = xmlHelper.appendNode(urlradiogroup, "hbox");
  var constRadio = xmlHelper.appendNode(urbox1, "radio", null,
                {"id":"constRadio", "label":"Constant:"} );
  var constInput = xulHelper.inputField(urbox1, context, "url",
                       "", 40, {flex:1});
  //xmlHelper.appendNode(urbox1, "textbox", null,
  //          {"value":context.conf["url"]||"", "flex":"1"});
  var urbox2 = xmlHelper.appendNode(urlradiogroup, "hbox");
  var pathRadio = xmlHelper.appendNode(urbox2, "radio", null,
          {"id":"pathRadio", "label":"Variable:"});
  var urlJpField = xulHelper.jsonPathField(urbox2, this, this.conf, "urljp");
  // reflect saved values
  if (context.conf["url"]) {
    urlradiogroup.selectedItem = constRadio;
  } else if (context.conf["urljp"]) {
    urlradiogroup.selectedItem = pathRadio;
  }
}; // drawGeneralTab


Httpclient.prototype.drawRequestTab = function (surface, context, tabs) {
  var vb = xmlHelper.appendNode(surface, "vbox", null,
                                {"flex":1,"align":"stretch"} );
  var urlJpField = xulHelper.jsonPathField(vb, this, this.conf, "reqjp", "Request" );
  var hdrCheck = xulHelper.checkbox(vb, this, "hdrcheck",
                                    "Add custom headers to the request");
  var hdrJpField = xulHelper.jsonPathField(vb, this, this.conf, "hdrjp", "Headers" );
};


//////////////////
// Run


Httpclient.prototype.getUrl = function (task) {
    var url = this.conf['url'];
    if (!url) {
      url = jsonPathHelper.getFirst(this.conf['urljp'], task.data);
    }
    if (typeof url !== "string") {
      throw new StepError("URL not specified (value was: " + url+")");
    }
    return url;
};

Httpclient.prototype.getHeaders = function (task) {
  var headers = {};
  if ( this.conf['hdrcheck'] ) {  // custom headers wanted
    var hstr = jsonPathHelper.getFirst(this.conf['hdrjp'], task.data);
    var harr = hstr.split("\n");
    for ( var i in harr ) {
      var hline = harr[i];
      hline = hline.replace( /^#.*$/, "" ); // skip comment lines
      if ( hline ) {
        var m = hline.match( /^([^:]+)\s*:\s*(.*)$/ );
        if ( m ) {
          var k = m[1];
          var v = m[2];
          headers[k]=v;
        } else {
          throw new StepError ("Invalid header line '" + hline + "'");
        }
      }
    }
  }
  return headers;
};


Httpclient.prototype.run = function (task) {
  var url=this.getUrl(task);
  //url = jsonPathHelper.inlineReplace(url, task.data);
    // No need to replace vars again, we took from a variable already
  //var req = this.conf['request'];
  var req = null; // default to no request (as in get)
  var reqtype = this.conf['type'] ;
  if ( reqtype == "POST" ) {
    var reqjp = this.conf['reqjp'];
    if ( ! reqjp )
      throw new StepError("No request specified");
    req = jsonPathHelper.getFirst(reqjp, task.data);
    // req = jsonPathHelper.inlineReplace(req, task.data); NO! already replaced
  }
  var hdr = this.getHeaders(task);
  // Inside the engine, we can just fetch the page.
  if (!core.inBuilder) {
    var dom = xmlHelper.fetchDoc( url, false, false, reqtype, req, hdr );
    this.task.connector.setPageOverride(dom,url);
    return;
  }
  // Inside the builder, we need to do a lot more to get a
  // a decent page to display. Just getting it to blank is a mess,
  // as pageload is supposed to be asynchronous.
  var context = this;
  var event = "DOMContentLoaded";
  var status = 0; // 0=not started, 1=loading, 2=done

  var eventhandler = function (e) { // This gets called once we have a blank page
    //task.debug("event: " + event );
    try {
      if (e) {
        core.getBrowser().removeEventListener(event, eventhandler, false);
      }
      var doc = task.connector.getRealPageDoc();
      doc.body.innerHTML = "HTTP client sending a " +
        reqtype + " request to <br/> " +
        "<a href=\"" + url +"\" >" + url + "</a> <p/>\n";
      status = 1;
      var dispreq = req;
      if ( !dispreq ) dispreq = "";
      dispreq = textHelper.encodeEntities( dispreq );
      doc.body.innerHTML += "<p/>" + dispreq + "<br/>\n";
      task.debug("About to " + reqtype + " " + url );
      //var reqdom = xmlHelper.docFromString(req);
      var startTime = new Date();
      var dom = xmlHelper.fetchDoc( url, false, false, reqtype, req, hdr );
      var endTime = new Date();
      var elapsed = endTime - startTime;
      //doc.body.innerHTML += "<p/><b>B</b><br/>\n";
      task.connector.setPageOverride(dom,url);
      task.debug( reqtype +" done in " + elapsed + " ms");
      doc.body.innerHTML += "<p/><b>OK</b>\n";
      status = 2;
      //task.debug("Looking at display doc\n");
      //task.debug("" + doc.body );
      htmlHelper.renderXml( dom, doc, doc.body)
    } catch(err) {
      task.debug("Httpclient caught an exception: " + err );
      doc.body.innerHTML += "<p/><b>FAIL</b><br/>" + err + "<br/>\n";
      if ( err.responseXML ) {
        doc.body.innerHTML += "The server responded <br/> \n";
        htmlHelper.renderXml( err.responseXML, doc, doc.body);
        //task.connector.setPageOverride(err.responseXML,url);
        // Keep the error XML too, it may contain important error messages
        doc.body.innerHTML += "<p/>\n";
      } else if ( err.responseText ) {
        doc.body.innerHTML += "The server said: <br/> \n";
        doc.body.innerHTML += textHelper.encodeEntities(err.responseText) +
              "<p/>\n";
      }
      if ( err.fileName && err.lineNumber )
        doc.body.innerHTML += err.fileName + ":" + err.lineNumber + "<br/>\n";
      throw new StepError( err );
    }
    if (e) {
      task.debug("Resuming task");
      task.resume();
    }
    }; // eventhandler

    // If we time out, the loading of about:blank failed,
    // or (much more likely), fetching the raw XML took
    // too long.
    var interruptcallback = function() {
        task.debug("in task interrupt function. st=" + status);
        if ( status == 2)
            return true;
        task.warn("Timed out waiting for raw XML from " + url);
        return false;
    }

    //task.debug("About to blank the page");
    var curloc = this.getPageDoc().location;
    if (curloc == "about:blank" || curloc == null ) {
      task.debug("already on a blank page, reusing it");
      eventhandler(false);
    } else {
      task.debug("About to blank the page (cur=" + curloc + ")");
      core.getBrowser().addEventListener(event, eventhandler, false);
      task.interrupt(30000,interruptcallback);  // 30 secs
      core.getBrowser().loadURI("about:blank");
    }

};


//////////////////
// Housekeeping

Httpclient.prototype.getClassName = function () {
  return "Httpclient";
};

Httpclient.prototype.getDisplayName = function () {
  return "Httpclient";
};

Httpclient.prototype.getDescription = function () {
  return "Translate a complex query into a search string";
};

Httpclient.prototype.getVersion = function () {
  return "1.0";
};

// Not much point in a renderArgs, way too complex to show in the builder
// Show the type (GET/POST), just to have something
Httpclient.prototype.renderArgs = function () {
  if ( ! this.conf['type'] )
    return "";
  return this.conf['type'];
};

Httpclient.prototype.capabilityFlagDefault = function ( flag ) {
  //dump("checking query-and, conf = " + JSON.stringify(this.conf) + "\n");
  if (flag == "webservice-connector")
    return true;
  var used = this.getUsedArgs();
  for ( var a in used ) {
    if ( flag == "index-" + a )
      return true;
  }
  return null;
};

Httpclient.prototype.getUsedArgs = function () {
  // Gather used arguments from inline JSONpaths
  let args = [];
  let usedArgRegex = /\{\$\.input\.(.+?)\}/g;
  let match;
  while ((match = usedArgRegex.exec(this.conf['reqjp'])) !== null) args.push([match[1]]);
  while ((match = usedArgRegex.exec(this.conf['urljp'])) !== null) args.push([match[1]]);
  return args;
}


Httpclient.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  // TODO - Add something here, when/if making the next version
  return true;
};

