var EXPORTED_SYMBOLS = ["progressListen"];
Components.utils.import("resource://indexdata/runtime/core.js");

const STATE_START = Components.interfaces.nsIWebProgressListener.STATE_START;
const STATE_TRANSFERRING = Components.interfaces.nsIWebProgressListener.STATE_TRANSFERRING;
const STATE_STOP = Components.interfaces.nsIWebProgressListener.STATE_STOP;
const STATE_REDIRECTING = Components.interfaces.nsIWebProgressListener.STATE_REDIRECTING;
const STATE_IS_DOCUMENT = Components.interfaces.nsIWebProgressListener.STATE_IS_DOCUMENT;
const NOTIFY_ALL = Components.interfaces.nsIWebProgress.NOTIFY_ALL;

const OBSRV = Components.classes["@mozilla.org/observer-service;1"]
  .getService(Components.interfaces.nsIObserverService);

var progressListen = {
  started: null,
  browser: null,
  task: null,
  redirectedFrom: null,
  waitXHR: true,
  quietTime: 50,
  quietTimer: Components.classes["@mozilla.org/timer;1"]
    .createInstance(Components.interfaces.nsITimer),
  defaultConf: {
    quietTime: 50,
    waitXHR: true,
  },

  getDisplayName: function() {
    return "nsIWebProgressListener and nsIObserverService";
  },

  draw : function(surface, conf) {
    Components.utils.import('resource://indexdata/util/xmlHelper.js');

    xmlHelper.appendNode(surface, "label", null,
      { control: "quietTime", value:"New load threshold (ms):" });
    var quietTime = xmlHelper.appendNode(surface, "textbox", null,
      { id:"quietTime", value:conf.quietTime||this.defaultConf.quietTime});
    quietTime.addEventListener("input", function(e) {
      conf.quietTime = parseInt(quietTime.value);
    }, false);

    var attributes = { label: "Wait for XMLHttpRequests? (nsIObserver)" };
    if (conf.waitXHR || (conf.waitXHR === undefined && this.defaultConf.waitXHR))
      attributes.checked = true;
    var check = xmlHelper.appendNode(surface, "checkbox", null, attributes);
    check.addEventListener("command", function(e) {
      conf.waitXHR = this.checked;
    }, false);
  },

  wait: function(task, conf, step) {
    this.browser = core.getBrowser();
    this.task = task;
    this.step = step;

    // conf checking and defaults
    if (conf.waitXHR===undefined)
      this.waitXHR = this.defaultConf.waitXHR;
    else
      this.waitXHR = conf.waitXHR;
    if (conf.quietTime)
      this.quietTime = conf.quietTime;
    else
      this.quietTime = this.defaultConf.quietTime;

    this.started = {observer:[], progress:[]};

    if (this.waitXHR) {
      OBSRV.addObserver(this, "http-on-modify-request", false);
      OBSRV.addObserver(this, "http-on-examine-response", false);
      OBSRV.addObserver(this, "http-on-examine-cached-response", false);
    }
    this.browser.addProgressListener(this);
  },

  detatch: function () {
      if (this.browser) this.browser.removeProgressListener(this);
      this.browser = null;
      if (this.waitXHR) {
        OBSRV.removeObserver(this, "http-on-modify-request");
        OBSRV.removeObserver(this, "http-on-examine-response");
        OBSRV.removeObserver(this, "http-on-examine-cached-response");
      }
  },

  onTimeout: function () {
    for (let key in this.started) {
      let started = this.started[key];
      this.task.warn("(" + key
                     + ") Following pages taking too long to finish:",
                     this.step);
      for (let i=0; i<started.length; i++) {
        this.task.warn("*" + started[i].name, this.step);
      }
    } 
  },

  // This is implementing nsISupports and lets things know what interfaces
  // this object handles.  Naturally we're a progress listener but we also
  // can provide weak references to ourself thanks to XPConnect.
  QueryInterface: function(aIID) {
    if (aIID.equals(Components.interfaces.nsIWebProgressListener) ||
        aIID.equals(Components.interfaces.nsIObserver) ||
        aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
        aIID.equals(Components.interfaces.nsISupports))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },

  removeRequest: function (aRequest, key) {
    let started = this.started[key];
    for (var i=0; i<started.length; i++) {
      if (started[i] === aRequest) {
        started.splice(i, 1);
        this.task.debug("  REMOVED request: " + aRequest.name, this.step);
        break;
      }
    }
  },

  requestStart: function (aRequest, key) {
    // Guarantee unique requests
    this.removeRequest(aRequest, key);
    this.task.info("  started: " + aRequest.name, this.step);
    this.task.addRunDatumUrlEvent(aRequest.name, "start", this.step);
    this.started[key].push(aRequest);
  },

  keysEmpty: function (obj) {
    let total = 0;
    for (let key in obj) {
      total += obj[key].length;
    }
    return total === 0;
  },

  requestStop: function (aRequest, key) {
    let httpChannel;
    let statusText = "";
    // Not all requests are HTTP channels
    try {
      //TODO: This works but why slow it down more, commenting just in case
      //httpChannel = aRequest.QueryInterface(Components.interfaces.nsIHttpChannel);
    } catch (e) {
    }
    // TODO: This slows it down too much or something and responses get missed
    if (false && typeof(httpChannel) === 'object') {
      statusText += " ("+ httpChannel.responseStatus + " " + httpChannel.responseStatusText + ") ";
      if (httpChannel.responseStatus < 400) {
        this.task.info("  completed" + statusText + aRequest.name, this.step);
      } else {
        this.task.warn("  failed" + statusText + aRequest.name, this.step);
      }
      var headerText = "  REQUEST: \n";
      let visitor = {
        "channel": httpChannel,
        "host":httpChannel.URI.host,
        "visitHeader": function (header, value) {
          headerText += "  " + header + ": " + value + "\n"
        }
      }
      httpChannel.visitRequestHeaders(visitor);
      this.task.debug(headerText, this.step);
      headerText = "  RESPONSE: \n";
      httpChannel.visitResponseHeaders(visitor);
      this.task.debug(headerText, this.step);
    } else {
      //this.task.info("  completed (no HTTP status) " + aRequest.name, this.step);
      this.task.info("  completed " + aRequest.name, this.step);
    }

    this.task.addRunDatumUrlEvent(aRequest.name, "stop", this.step);
    // Remove it from the array of pages we're waiting for
    this.removeRequest(aRequest, key);
    if (this.keysEmpty(this.started)) {
      var context = this;
      this.task.info("  All pages loaded, waiting.", this.step);
      // The array of pending pages is empty, wait to allow new requests to start.
      this.quietTimer.initWithCallback(function () {
        if (context.keysEmpty(context.started)) {
          context.task.info("No new requests, load complete.", context.step);
          Components.utils.import('resource://indexdata/util/waitForLoad.js');
          waitForLoad.detatch();
        }
      }, this.quietTime, Components.interfaces.nsITimer.TYPE_ONE_SHOT);
    }
  },

  observe: function(subject, topic, data) {
    subject.QueryInterface(Components.interfaces.nsIRequest);
    subject.QueryInterface(Components.interfaces.nsIHttpChannel);
    if ((subject.notificationCallbacks)) {

      try
      {
          var xhrRequest = subject.notificationCallbacks.getInterface(Components.interfaces.nsIXMLHttpRequest);
          if (xhrRequest) {
 this.task.debug (topic +  " XHR OBSERVED! " + subject.name);
            if (topic=="http-on-modify-request")
              this.requestStart(subject, 'observer');
            if (topic=="http-on-examine-response" || topic=="http-on-examine-cached-response")
              this.requestStop(subject, 'observer');
          }
      }
      catch (e) {}
    }
  },

  onStateChange: function(aWebProgress, aRequest, aFlag, aStatus) {
    let started = this.started.progress;
    // This fires when the load event is initiated

    // Old dump code to get hex output
    // dump("STATE FLAG: 0x" + parseInt(aFlag.toString(2).substr(-8),2).toString(16) + " " + aRequest.name + "\n");

    // Function to dump a list of associated flags.
    var wplFlagDump = function(flags, req) {
      var output;
      var flagStrings = "STATE_START STATE_REDIRECTING STATE_TRANSFERRING STATE_NEGOTIATING STATE_STOP STATE_IS_REQUEST STATE_IS_DOCUMENT STATE_IS_NETWORK STATE_IS_WINDOW STATE_RESTORING STATE_IS_INSECURE STATE_IS_BROKEN STATE_IS_SECURE STATE_SECURE_HIGH STATE_SECURE_MED STATE_SECURE_LOW".split(" ");
      output = ("onStateChange FLAGS! " + req.name + " ::: ");
      for (var i=0; i<flagStrings.length; i++) {
        if (eval("Components.interfaces.nsIWebProgressListener." + flagStrings[i] + " & flags"))
          output += (flagStrings[i] + " ");
      }
      return output;
    };

    this.task.debug (wplFlagDump(aFlag, aRequest), this.step);
    this.task.debug (started.length + " requests BEFORE:", this.step);
    for (var i=0; i<started.length; i++, this.step) {
      this.task.debug(i + ". " + started[i].name, this.step);
    }
    // Might be && aFlag & STATE_IS_DOCUMENT but apparently there
    // are things that aren't documents that aren't considered to be 
    // contained within the document (documents aren't stopped until
    // their children are and a redirect will change the source request
    // to STATE_STOP only once it itself has stopped so theoretically...).
    //
    // No ill effects so far this way beyond a lot more stuff being tracked
    // which probably is why we had it this way as the previous heuristicky
    // business got hung up on things now and then.
    if (aFlag & STATE_START && (aRequest.name.slice(0, 4) == "http")) {
      this.requestStart(aRequest, 'progress');
    }
    if (aFlag & STATE_STOP && (aRequest.name.slice(0, 4) == "http")) {
      this.requestStop(aRequest, 'progress');
    }
    this.task.debug (started.length + " requests AFTER:");
    for (var i=0; i<started.length; i++) {
      this.task.debug(i + ". " + started[i].name, this.step);
    }
    return 0;
  },

  onLocationChange: function(aProgress, aRequest, aURI) {
    /*
    // Location: header is sent before any page content that could trigger
    // a new request and .equals doesn't find it ie. it's not giving a
    // reference to the same request object so the best we can do is assume
    // that whatever started most recently is what caused the redirect.
    if ((aRequest.name.slice(0, 4) == "http")) {
      this.task.info("  Location changed to: " + aRequest.name + "(via onLocationChange)", this.step);
      //this.task.info("  Assuming we've redirected from: " + this.started.pop().name, this.step);
      //this.requestStart(aRequest);
    }
    */
    return 0;
  },

  onProgressChange: function(aProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress) {
      var dumpRequest = aRequest
      if ( dumpRequest == null ) // defensive coding
          dumpRequest = { name: "NULL" };
    this.task.debug("  Progress: " + dumpRequest.name + " cur=" + aCurSelfProgress + " max=" + aMaxSelfProgress + " curTotal=" + aCurTotalProgress + " maxTotal=" + aMaxTotalProgress, this.step);
    return 0;
  },
  onStatusChange: function() {return 0;},
  onSecurityChange: function() {return 0;},
  onLinkIconAvailable: function() {return 0;}
};
