%define idmetaversion %(. ./IDMETA; printf $VERSION )
Summary: Connector Framework
Name: cf
Version: %{idmetaversion}
Release: 1indexdata
%define is_suse %(test -e /etc/SuSE-release && echo 1 || echo 0)
BuildRequires: gcc gcc-c++ pkgconfig libxslt-devel readline-devel
BuildRequires: libmetaproxy6-devel >= 1.4.0
BuildRequires: libxml2-devel
BuildRequires: cf-xulrunner10-devel
License: proprietary
Group: Applications/Internet
Vendor: Index Data ApS <info@indexdata.dk>
Source: cf-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Packager: Adam Dickmeiss <adam@indexdata.dk>
URL: http://www.indexdata.com/connector-framework

%description
Connector Framework for CentOS 5 / SuSE 11 / RHEL 5.

%package engine
Summary: CF Engine
Group: Applications/Internet
Requires: cf-xulrunner10
Requires: metaproxy6, netpbm-progs, xorg-x11-apps, libmetaproxy6
%if %is_suse
Requires: xorg-x11-server-extra
%else
Requires: xorg-x11-server-Xvfb
%endif
Obsoletes: cf-xvfb

%description engine
CF Engine core

%package zserver
Summary: CF Z39.50 server
Group: Applications/Internet
Requires: cf-engine = %{version}

%description zserver
Enables CF modules on port 9003 for Z39.50.

%package doc
Summary: CF documentation in HTML
Group: Applications/Internet

%description doc
Documentation for the Connector Framework Engine

%package squid
Summary: Proxy CF via squid
Group: Applications/Internet
Requires: squid, cf-engine = %{version}

%description squid
Enables CF to use squid for proxying traffic to the outside world.

%prep
%setup

%post engine
if [ -d /usr/lib64/metaproxy6/modules ]; then
       	if [ ! -e /usr/lib64/metaproxy6/modules/metaproxy_filter_cf.so ]; then
		ln -s /usr/lib64/cf/metaproxy_filter_cf.so /usr/lib64/metaproxy6/modules
	fi
fi
if [ -d /etc/metaproxy/filters-available ]; then
	if [ "`readlink /etc/metaproxy/filters-available/cf.xml`" = \
		"/usr/share/cf/metaproxy/cf.xml" ]; then
		rm -f /etc/metaproxy/filters-available/cf.xml
	fi
	if [ ! -e /etc/metaproxy/filters-available/cf.xml ]; then
		ln -sf /etc/cf/cf.xml /etc/metaproxy/filters-available
		ln -sf ../filters-available/cf.xml /etc/metaproxy/filters-enabled/cf.xml
	fi
fi
if [ -f /var/run/metaproxy.pid ]; then
	/sbin/service metaproxy restart
fi
%preun engine
if [ $1 = 0 ]; then
	rm -f /etc/metaproxy/filters-available/cf.xml
	rm -f /etc/metaproxy/filters-enabled/cf.xml
	if [ -f /var/run/metaproxy.pid ]; then
		/sbin/service metaproxy restart
	fi
fi

%postun engine
if [ $1 = 0 ]; then
	rm -f /usr/lib64/metaproxy6/modules/metaproxy_filter_cf.so
fi

%post zserver
if [ -d /etc/metaproxy/ports.d -a -d  /etc/metaproxy/routes.d ]; then
    if [ ! -e /etc/metaproxy/ports.d/cf-zserver.port.xml ]; then
        ln -s /etc/cf-zserver/cf-zserver.port.xml /etc/metaproxy/ports.d
    fi
    if [ ! -e /etc/metaproxy/routes.d/cf-zserver.route.xml ]; then
        ln -s /etc/cf-zserver/cf-zserver.route.xml /etc/metaproxy/routes.d
    fi
    if [ -f /var/run/cf-zserver.pid ]; then
	/sbin/service cf-zserver stop
    fi
    if [ -f /var/run/metaproxy.pid ]; then
	/sbin/service metaproxy restart
    fi
fi

%preun zserver
if [ $1 = 0 ]; then
    rm -f /etc/metaproxy/ports.d/cf-zserver.port.xml
    rm -f /etc/metaproxy/routes.d/cf-zserver.route.xml
    if [ -f /var/run/metaproxy.pid ]; then
	/sbin/service metaproxy restart
    fi
fi

# ------ BUILD --------
%build
# CF programs
cd engine/src
make clean
PKG_CONFIG_PATH=/usr/cf-xulrunner/lib64/pkgconfig make \
	OPT_FLAGS="-g -O" \
	YAZ_CONFIG=/usr/bin/yaz-config \
	MP_CONFIG=/usr/bin/metaproxy-config

# CF documentation
cd ../../engine/doc
make
cd ../..

# ------ INSTALL --------
%install
rm -fr ${RPM_BUILD_ROOT}

# install engine
cd engine/src
make DESTDIR=${RPM_BUILD_ROOT} libdir=%{_libdir} install
cp squid.js ${RPM_BUILD_ROOT}/usr/share/cf/app/defaults/preferences/user.js
mkdir -p ${RPM_BUILD_ROOT}/etc/init.d
mkdir -p ${RPM_BUILD_ROOT}/etc/sysconfig
mkdir -p  ${RPM_BUILD_ROOT}/etc/logrotate.d
mkdir -p  ${RPM_BUILD_ROOT}/etc/cron.daily
cd ..
cp -r etc ${RPM_BUILD_ROOT}/
cd doc
make prefix=${RPM_BUILD_ROOT}/usr libdir=${RPM_BUILD_ROOT}/%{_libdir} install
cd ../../rpm
patch ${RPM_BUILD_ROOT}/etc/cf/cf.xml cf.xml.patch
patch ${RPM_BUILD_ROOT}/etc/cf-zserver/cf-zserver.route.xml cf-zserver.route.xml.patch
install -m755 cf-clean_sessions.cron ${RPM_BUILD_ROOT}/etc/cron.daily/cf-clean_sessions
cd ..

%clean
rm -fr ${RPM_BUILD_ROOT}

%files engine
%defattr(-,root,root)
/usr/bin/cfrun
/usr/share/cf/modules
/usr/share/cf/templates
/usr/share/cf/app/components
/usr/share/cf/app/defaults/preferences/prefs.js
/usr/share/cf/app/chrome.manifest
/usr/share/cf/app/chrome/content/engine.xul
/usr/share/man/man1/cfrun.*
/usr/share/man/man8/cf_webservice.*
/etc/cf
%config(noreplace) /etc/cf/cf.xml
%{_libdir}/cf/*.so

%files zserver
%defattr(-,root,root)
/etc/cf-zserver/CF2MARC21slim.xsl
%config(noreplace) /etc/cf-zserver/cf-zserver.port.xml
%config(noreplace) /etc/cf-zserver/cf-zserver.route.xml
/usr/share/man/man8/cf-zserver.*
/etc/cron.daily/cf-clean_sessions

%files doc
%defattr(-,root,root)
/usr/share/doc/cf

%files squid
%defattr(-,root,root)
/usr/share/cf/app/defaults/preferences/user.js

