#/bin/sh
# Copyright (c) 2012 IndexData ApS. http://indexdata.com
#
# unittests.sh - Find and run all unit tests

: ${DEBUG=1}
log_dir=logs

export CF_DISPLAY_LOCK=/tmp/cf-xvfb-$(logname)
case `uname` in 
   Linux ) ;;
       * ) export CF_APP_PATH=`pwd` ;;
esac

UNITS=`cd ../../builder/modules; grep -rl unitTest * |
       grep -e \.js$ |
       sed s/\.js$//`

for U in $UNITS
do
  # verbose output
  if [ $DEBUG -gt 0 ]; then
    ./cfrun -u $U || exit 1
  else
    out=$log_dir/`echo $U | sed 's,/,-,g'`.log
    if ./cfrun -u $U > $out 2>&1; then
    	egrep '^Unit test' $out
    else
	tail -n 12 -- $out
	exit 1
    fi
  fi
done

N=`echo $UNITS | wc -w`
echo "All $N unit tests OK"
exit 0 

