var EXPORTED_SYMBOLS = ["testEditor"];
Components.utils.import("resource://indexdata/util/xmlHelper.js");
Components.utils.import("resource://indexdata/ui/app.js");

const NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";

var testEditor = {
  test: null,
  doc: null,
  win: null,
  
  getActiveTest: function () {
    return this.test;
  },

  onSetName: function (txtBox) {
    this.test.setName(txtBox.value);
    app.notify("testNameChanged");
  },

  setActiveTest: function (test) {
    this.test = test;
  },

  setXul: function (win) {
    this.win = win;
    this.doc = win.document;
  },

  onTestRemove: function (idx) {
    if (app.selectedTask == null) return;
    dump("Switching test to " + idx +"\n");
    idx = parseInt(idx);
    taskPane.switchActiveTest(app.selectedTask.getTests()[idx]);
    //FIXME this should be done using publish/subscribe model (via app)
    taskPane.refreshArguments();
  },

  refreshTestName: function() {    
    var txtbox = this.doc.getElementById("activeTestName");
    txtbox.value = this.test.getName();
  },

  /*
     The following is not used before we figure out what in-builder
     testing functionlity we want
  */
  addAssert: function (path, value) {
    this.test.createAssert(path, value);
    this.refreshAssertList();
    if (this.win) this.win.resizeBy(0,30);
  },

  getSelAsrtIdx: function () {
    var selected = this.doc.getElementById("assertList").selectedItem;
    return selected.value;
  },

  deleteSelAssert: function () {
    var num = parseInt(this.getSelAsrtIdx());
    var assert = this.test.getAssert(num);
    this.test.removeAssert(assert);
    this.refreshAssertList();
    this.win.resizeBy(0,-30);
  },

  refreshAll: function () {
    this.refreshTestName();
    this.refreshAssertList();
  },

  refreshAssertList: function ()  {
    if (this.doc == null) return;
    var rgroup = this.doc.getElementById("assertList");
    xmlHelper.emptyChildren(rgroup);
    var asserts = this.test.getAsserts();
    var hasAssert = false;
    for (var i=0; i<asserts.length; i++) {
      hasAssert = true;
      var assert = asserts[i];
      xmlHelper.appendNode(rgroup, "radio", null, 
          {"label" : "Assert " + assert.getValue() + " on " + assert.getPath(),
          "value" : i });      
    }
    if (!hasAssert) xmlHelper.appendNode(rgroup, "label", 
        "No asserts specified");
  }
};
