#!/bin/sh
# assumes pwd is engine/src

DIR=`dirname $0`            # ../../connectors/cf-zserver-regression
PLAINDIR=`basename $DIR`    # cf-zserver-regression
: ${proxy="localhost:3128"}
: ${diff_opt="-u"}
: ${REGRESSION_FATAL=false}
: ${MAKE_OUT=false}

GRET=0
error () {
    $REGRESSION_FATAL && exit 1
    GRET=1
}

p=`echo $proxy | sed 's/:/ /'`; 
if ! echo "GET /" | nc $p >/dev/null 2>&1; then
    echo ">>> proxy $proxy is not available. Skip proxyip test! <<<"
    exit 0
fi

echo "running regression in $DIR"

CONNECTORLIST=`cd $DIR/..; ls $PLAINDIR/*.cf`
for C in $CONNECTORLIST
do
    CNAME=`basename $C .cf`
    CDIR=`dirname $C`
    if [ $CDIR = "." ]
    then
      CONNECTOR=$CNAME
    else
      CONNECTOR=$CDIR/$CNAME
    fi

    RET=0
    QRYFILE=$DIR/$CNAME.query
    # Make sure we have a query file, with plain "water" if need be
    test -f $QRYFILE ||
      echo "@attr 1=1016 @attr 2=3 @attr 3=3 @attr 4=2 "\
           "@attr 5=100 @attr 6=1 water" > $QRYFILE
    LOG=$DIR/$CNAME.log
    rm -f $LOG

    case $CONNECTOR in 
	*proxy-broken* ) proxyip="?proxy=localhost:1" ;;
	* ) 		 proxyip="?proxy=$proxy" ;;
    esac

    echo " setting proxyip: \"$proxyip\""
    while read QRY
    do  # for each line in the file
      echo "======================" >> $LOG
      echo $QRY  >> $LOG
     
      zoomsh "open localhost:9070/${CONNECTOR}${proxyip}" \
		"set count 2" "search $QRY" "quit"  |
         sed 's/localhost:9070/unix:socket/g' >>$LOG
      test $? -ne 0 && (
         echo zoomshell failed with $?
         error
      )
    done < $QRYFILE
    if test -f $DIR/$CNAME.out; then
	diff $diff_opt $DIR/$CNAME.out $LOG
	if test $? -ne 0; then
	    echo "  $CNAME: differ"
            error
	else
	    echo "  $CNAME: OK"
	fi
    elif $MAKE_OUT; then
	echo " $CNAME: Making first time"
        cp $LOG $DIR/$CNAME.out
        error
    else
        echo "$CNAME FAIL!"
        echo "  Missing file: $CNAME.out"
        echo "  Please check that $CNAME.log looks right, and copy it to $CNAME.out"
        echo "  And add it to git with "
        echo "    cd $DIR; git add $CONNECTOR.out"
        echo "  (make sure the .query file is in git too!)"
        error
    fi    
  
done # connector loop

exit $GRET
