#!/bin/sh
summary=false
while test $# -gt 0; do
    case "$1" in
        --summary)
            summary=true
	    ;;
        -*)
            echo "Unknown option $1"
	    exit 1
            ;;
        *)
            fname=$1
    esac
    shift 
done
if test -z "$fname"; then
    echo "Usage:"
    echo "$0 pathto/log/cf-zserver.log"
    exit 1
fi
if $summary; then
    for c in boot search parse next; do
	echo -n "$c "
	awk "BEGIN {load=0} /\[log\]\ RTINFO\ Task \[$c\].*Load/ {load+=\$13} /\[log\]\ timing/ {print \$5 \" \" \$6 \" \" \$7 \" \" \$8 \" load \" load; load=0}" < $fname|sed s@,@.@g| sed s@=@\ @g| awk "BEGIN { count = 0; } /$c/ { user += \$3; real += \$5; sys += \$7; load += \$9; count++} END {print count \" \" user \" \" real \" \" sys \" \" load}"
    done
else
    awk "/\[log\]\ timing/ {print \$5 \" \" \$6 \" \" \$7 \" \" \$8}" < $fname|sed s@,@.@g|sed s@=@\ @g
fi
