var EXPORTED_SYMBOLS = ["EncodeDecode"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
var EncodeDecode = function () {
  this.conf = {
    format: 'json',
    mode: 'decode',
  };
};
EncodeDecode.formats = {json:"JSON"}; EncodeDecode.prototype = new Step();
EncodeDecode.prototype.constructor = EncodeDecode;
EncodeDecode.prototype.init = function() {};
EncodeDecode.prototype.draw = function(surface) {
  xulHelper.jsonPathMapField(surface, this, "in", "out");
  xulHelper.selectField(surface, this, "format", "Format", EncodeDecode.formats);
  var modeRadioGroup = xmlHelper.appendNode(surface, "radiogroup");
  var modeRadios = {};
  modeRadios.encode = xmlHelper.appendNode(modeRadioGroup, 'radio', null, {'value':'encode', 'label':'Encode'});
  modeRadios.decode = xmlHelper.appendNode(modeRadioGroup, 'radio', null, {'value':'decode', 'label':'Decode'});
  modeRadioGroup.selectedItem = modeRadios[this.conf.mode];
  var context = this;
  modeRadioGroup.addEventListener('select', function(e) {
    context.conf.mode = e.target.value;
  }, false);
};
EncodeDecode.prototype.run = function (task) {
  switch (this.conf.format) {
  case 'json':
     var encode = function (value) { return JSON.stringify(value); };
     var decode = function (value) { return JSON.parse(value); };
     break;
  default:
    throw new StepError("Invalid format.");
  };
  if (this.conf.mode === 'encode') {
    jsonPathHelper.map(this.conf.in, this.conf.out, encode, task.data);
  } else { 
    jsonPathHelper.mapElements(this.conf.in, this.conf.out, decode, task.data);
  }
};
EncodeDecode.prototype.getClassName = function () { return "EncodeDecode"; };
EncodeDecode.prototype.getDisplayName = function () { return "Encode/Decode"; };
EncodeDecode.prototype.getDescription = function () {
  return "Encode and decode various formats";
};
EncodeDecode.prototype.getVersion = function () { return "1.0"; };
EncodeDecode.prototype.getUsedArgs = function () {
  if (this.conf.in.path === "$.input") return [this.conf.in.key];
};
EncodeDecode.prototype.renderArgs = function () {
  let args = this.conf.mode + " " + this.conf.format
  if (this.conf.in) args += " " + this.conf.in.key + " -> " + this.conf.out.key;
  return args;
};
EncodeDecode.prototype.upgrade = function (confVer, curVer, conf) {
  if (confVer > curVer) return false;
  return true;
};
