var EXPORTED_SYMBOLS = ["History"];
Components.utils.import("resource://indexdata/runtime/core.js");
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import("resource://indexdata/util/logging.js");
Components.utils.import('resource://indexdata/util/waitForLoad.js');
var logger = logging.getLogger();
var History = function () {
  this.conf = {};
  this.conf.wait = {};
  this.conf.wait.active = true;
};
History.prototype = new Step();
History.prototype.constructor = History;
History.prototype.init = function() {};
History.prototype.draw = function(surface) {
  waitForLoad.stepXul(surface, this.conf.wait);
};
History.prototype.run = function (task) {
  let browser = core.getBrowser();
  if (!browser.canGoBack) {
    logger.warn("Can't go back.", this);
  } else {
    logger.debug("Going back.", this);
    core.getBrowser().goBack();
    waitForLoad.wait(task, this.conf.wait, this);
  } 
};
History.prototype.getClassName = function () { return "History"; };
History.prototype.getDisplayName = function () { return "History"; };
History.prototype.getDescription = function () {
  return "Return to the previous page in session history";
};
History.prototype.getVersion = function () { return "1.0"; };
History.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer) return false;
};
