var EXPORTED_SYMBOLS = ["filterEditor"];

// Editor for the "HTTP filters" tab of the metadata editor

Components.utils.import("resource://indexdata/ui/app.js");
Components.utils.import("resource://indexdata/util/xmlHelper.js");
Components.utils.import("resource://indexdata/util/xulHelper.js");

var filterEditor = {
  doc: null,
  win: null,
  whitelist: null,
  blacklist: null,
  whitelistNode: null,
  blacklistNode: null,
  
  init: function (win) {
    var connector = this.getConnector();
    var props = connector.properties;
    this.win = win;
    this.doc = win.document;
    if (!props.whitelist) props.whitelist = [];
    if (!props.blacklist) props.blacklist = [];
    // make local copies of the lists, so we can click cancel
    this.whitelist = this.copyArray(props.whitelist);
    this.blacklist = this.copyArray(props.blacklist);
    //this.blacklist = connector.properties.blacklist;
    this.whitelistNode = this.doc.getElementById("cfWhitelist");
    this.blacklistNode = this.doc.getElementById("cfBlacklist");
    this.renderList(this.blacklist, this.blacklistNode);
    this.renderList(this.whitelist, this.whitelistNode);

    var cssCheck = this.doc.getElementById("cfBlockCss");
    var imageCheck = this.doc.getElementById("cfBlockImages");
    var objectCheck = this.doc.getElementById("cfBlockObjects");
    var checksFromProps = function() {
      if (props.block_images === undefined) props.block_images = true; 
      if (props.block_objects === undefined) props.block_objects = true; 
      imageCheck.checked = props.block_images;
      cssCheck.checked = props.block_css;
      imageCheck.checked = props.block_images;
      objectCheck.checked = props.block_objects;
    }
    var propsFromChecks = function() {
      props.block_css = cssCheck.checked;
      props.block_images = imageCheck.checked;
      props.block_objects = objectCheck.checked; 
      connector.updateContentFilter();
    }
    checksFromProps();
    cssCheck.addEventListener("command", propsFromChecks, false);
    imageCheck.addEventListener("command", propsFromChecks, false);
    objectCheck.addEventListener("command", propsFromChecks, false);
  },

  // little helper to make a local copy
  copyArray: function(array) {
    var arr = new Array( array.length);
    for ( var i in array ){
      arr[i] = array[i];
    }
    return arr;
  },
  
  getConnector: function () {
    return app.connector;
  },
  
  renderList: function (list, node) {
    xulHelper.clearList(node);
    var item;
    var box;
    for (var i=0; i<list.length; i++) {
      item = xmlHelper.appendNode(node, "listitem", null, 
        {"value":i, allowevents: true}, null, false);
      var cell = xmlHelper.appendNode(item, "listcell");
      box = xmlHelper.appendNode(cell, "textbox", null,
        { "flex":1, "value":list[i], 
          "class": "tight" });
      node.appendChild(item);
      box.addEventListener("input", function(e) {
        var pp = this.parentNode.parentNode;
        list[parseInt(pp.value, 10)] = this.value;
        app.set("canSave", true);
      }, false);
    }
    if (box) {
      box.focus();
      list.selectedItem = item;
    }
  },
  
  deleteSelected: function (list, node) {
    for (var i=0; i<node.selectedItems.length; i++) {
      list.splice(parseInt(node.selectedItems[i].value), 1);
    }
    app.set("canSave", true);
  },
  addBlack: function () {
    this.blacklist.push('');
    this.renderList(this.blacklist, this.blacklistNode);    
  },
  addWhite: function () {
    this.whitelist.push('');
    this.renderList(this.whitelist, this.whitelistNode);
  },
  delBlack: function () {
    this.deleteSelected(this.blacklist, this.blacklistNode);
    this.renderList(this.blacklist, this.blacklistNode);    
  },
  delWhite: function () {
    this.deleteSelected(this.whitelist, this.whitelistNode);
    this.renderList(this.whitelist, this.whitelistNode);
  },
  
  saveFilter: function() {
    var props = this.getConnector().properties;
    props.whitelist = this.whitelist;
    props.blacklist = this.blacklist;
    app.connector.updateContentFilter();
  },
  
};
