/* This file is part of the Connector Framework
 * Copyright (C) 2008-2013 Index Data
 * See the file LICENSE for details.
 */

/** \file
 * \brief Testing varous CF utilities
 */

#include <string.h>
#include <stdlib.h>
#include <yaz/diagbib1.h>
#include <yaz/test.h>
#include "cf_assert.h"

static void test_assertions(void)
{
    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "xyz", &addinfo);
        YAZ_CHECK(addinfo && !strcmp("xyz", addinfo));
        YAZ_CHECK_EQ(errcode, YAZ_BIB1_PERMANENT_SYSTEM_ERROR);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "ERROR_AUTHENTICATION xyz", &addinfo);
        YAZ_CHECK(addinfo == 0);
        YAZ_CHECK_EQ(errcode, YAZ_BIB1_INIT_AC_AUTHENTICATION_SYSTEM_ERROR);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "blahERROR_AUTHENTICATION xyz", &addinfo);
        YAZ_CHECK(addinfo == 0);
        YAZ_CHECK_EQ(errcode, YAZ_BIB1_INIT_AC_AUTHENTICATION_SYSTEM_ERROR);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "ERROR_AUTHENTICATION:xahERROR_AUTHENTICATION:xyz", &addinfo);
        YAZ_CHECK(addinfo && !strcmp("xyz", addinfo));
        YAZ_CHECK_EQ(errcode, YAZ_BIB1_INIT_AC_AUTHENTICATION_SYSTEM_ERROR);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "ERROR_VERBATIM", &addinfo);
        YAZ_CHECK(addinfo == 0);
        YAZ_CHECK_EQ(errcode, YAZ_BIB1_UNSPECIFIED_ERROR);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "ERROR_ACCESS", &addinfo);
        YAZ_CHECK(addinfo == 0);
        YAZ_CHECK_EQ(errcode, YAZ_BIB1_ACCESS_TO_SPECIFIED_DATABASE_DENIED);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "ERROR_TOOMANYUSERS", &addinfo);
        YAZ_CHECK(addinfo == 0);
        YAZ_CHECK_EQ(
            errcode,
            YAZ_BIB1_INIT_AC_MAXIMUM_NUMBER_OF_SIMULTANEOUS_SESSIONS_FOR_);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "ERROR_BIB1", &addinfo);
        YAZ_CHECK(addinfo && !strcmp("ERROR_BIB1", addinfo));
        YAZ_CHECK_EQ(errcode, YAZ_BIB1_PERMANENT_SYSTEM_ERROR);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "xERROR_BIB1:2", &addinfo);
        YAZ_CHECK(addinfo == 0);
        YAZ_CHECK_EQ(errcode, 2);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "ERROR_BIB1:40", &addinfo);
        YAZ_CHECK(addinfo == 0);
        YAZ_CHECK_EQ(errcode, 40);
    }

    {
        int errcode = YAZ_BIB1_PERMANENT_SYSTEM_ERROR;
        const char *addinfo = 0;
        cf_interpret_assertions(&errcode, "ERROR_BIB1:40:b", &addinfo);
        YAZ_CHECK(addinfo && !strcmp(addinfo, "b"));
        YAZ_CHECK_EQ(errcode, 40);
    }

}

int main(int argc, char **argv)
{
    YAZ_CHECK_INIT(argc, argv);
    YAZ_CHECK_LOG();
    test_assertions();
    YAZ_CHECK_TERM;
}
/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */

