/* This file is part of the Connector Framework
 * Copyright (C) 2008-2013 Index Data
 * See the file LICENSE for details.
 */

/** \file
 * \brief Type7 sort main program
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <yaz/xmalloc.h>
#include <yaz/options.h>
#include <yaz/pquery.h>
#include <yaz/querytowrbuf.h>

#include "type7_sort.h"

int main(int argc, char **argv)
{
    char *input_pqf = 0;
    int r;
    char *arg;
    while ((r = options("", argv, argc, &arg)) != YAZ_OPTIONS_EOF)
    {
        switch (r)
        {
        case YAZ_OPTIONS_ERROR:
            fprintf(stderr, "Bad option: %s\n", arg);
            exit(1);
        case 0:
            input_pqf = arg;
        }
    }
    YAZ_PQF_Parser parser = yaz_pqf_create();
    ODR odr = odr_createmem(ODR_ENCODE);

    if (!input_pqf)
    {
        fprintf(stderr, "missing query\n");
        exit(1);
    }
    Z_RPNQuery *q = yaz_pqf_parse(parser, odr, input_pqf);
    yaz_pqf_destroy(parser);

    if (!q)
    {
        fprintf(stderr, "PQF parsing failed\n");
        exit(1);
    }
    struct sort_elem *sort_list = 0, *sl;
    NMEM nmem = nmem_create();
    WRBUF pqf_result = wrbuf_alloc();
    type7_sort(q, nmem, &sort_list);

    yaz_rpnquery_to_wrbuf(pqf_result, q);
    printf("%s\n", wrbuf_cstr(pqf_result));
    for (sl = sort_list; sl; sl = sl->next)
        printf("prio=%d field=%s flags=%s\n",
               sl->prio, sl->field, sl->flags);
    nmem_destroy(nmem);
    wrbuf_destroy(pqf_result);
    odr_destroy(odr);
    exit(0);
}

/*
 * Local variables:
 * c-basic-offset: 4
 * c-file-style: "Stroustrup"
 * indent-tabs-mode: nil
 * End:
 * vim: shiftwidth=4 tabstop=8 expandtab
 */
