# Copyright (c) 2010 IndexData ApS. http://www.indexdata.com
#
# TagCloud.pm - a wrapper for HTML::TagCloud

package Masterkey::Admin::TagCloud;
use HTML::TagCloud 0.34;

@ISA = ("HTML::TagCloud");

use strict;
use warnings;

use Encode;
use URI;
use HTML::Entities;
use Carp;

our $VERSION = '0.1';

sub add_term {
    my $self = shift;
    my($term, $incr) = @_;

    $incr = 1 if !defined $incr;

    $self->{_TERM}->{$term} += $incr;
}

sub generate {
    my $self = shift;
    my %args = @_;

    my $unparsed_uri = $args{'uri'} or return;
    my $query  = $args{'query'}  || "query";
    my $levels = $args{'levels'} || "8";

    # reset levels
    $self->{'levels'} = $levels;

    my $url = URI->new($unparsed_uri);
    while ( my ( $term, $counter ) = each %{ $self->{_TERM} } ) {
        $url->query_form( 'query', encode_entities($term) );
        $self->add( $term, $url->as_string, $counter );
    }
}

sub escape {
    my $js = shift;

    $js =~ s/'/\\'/g;
    $js =~ s/\n/ /g;

    return $js;
}

sub html_and_css_js { return escape( shift->html_and_css(@_) ); }
sub html_js         { return escape( shift->html_and_css(@_) ); }

1;

__DATA__

=head1 NAME

Facets - create faceted classification lists

=head1 SYNOPSIS

    use Masterkey::Admin::TagCloud;

This module is an extension for HTML::TagCloud. Please run `perldoc HTML::TagCloud' for more information.

=head1 FUNCTIONS

Available methods are:

=head2 new
	
	new(args...)

=cut

=head2 add_term

	add_term("term")

=cut

=head2 generate

	generate('uri'=> 'http://indexdata.com', 'query'=>'query', 'levels' => 8)

=cut

=head2 html

	html(args...)

=cut

=head2 html_js

	html_js(args...)

=cut

=head2 html_and_css_js

	html_and_css_js(args...)

=cut


=head1 AUTHOR

Wolfram Schneider

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Facets


You can also look for information at:

=over 2

=item * Masterkey demo site

L<http://mk2.indexdata.com>

=back


=head1 ACKNOWLEDGEMENTS

=head1 COPYRIGHT & LICENSE

Copyright 2010 Index Data ApS, all rights reserved.

=cut

