<%args>
$query => undef
$days => undef
</%args>
<%perl>
my $fullquery = $m->comp("/mc/make-fullquery.mc", query => $query, days => $days);

my $q = $m->notes("q");
my $admin = $m->notes("admin");
my $pluralType = $m->notes("pluralType");
</%perl>
   <h2><% $admin->caption("allObjectsHeading", $admin->caption("allObjects", "All $pluralType")) %></h2>
<%perl>
$m->comp("/mc/form.mc", query => $query, days => $days);
if (!defined $query) {
    return;
}

$m->comp("shownote.mc", which => "all");

my $user = $m->comp("/mc/utils/user.mc", require => 1) or return;
my $rs;
eval {
    my $realm = $user->field("identityId");
    $rs = $admin->torus()->sortedWorld($realm, $fullquery,
		utf8param($q, "start"), $admin->configValue("pageSize") || 50);
}; if ($@) {
    print $admin->exception2error($@);
    return;
}

my $n = $rs->alln();
my $facets = $rs->facets();
my $cloud = $rs->cloud();

my ($start_record, $last_record, $pageSize, $pagingHTML, $rangeHTML) =
    $m->comp("paging.mc", r => $r, alln => $n, query => $fullquery);

$m->comp("facets_output.mc", facets => $facets, cloud => $cloud, query => $fullquery);

</%perl>
   <% $rangeHTML %>
   <% $pagingHTML %>

   <table class="list">
    <tr>
     <th><% $admin->caption("nameObject", "Name") %></th>
% if ($admin->configValue("showProvider")) {
     <th><% $admin->caption("providerObject", "Provider") %></th>
% }
     <th><% $admin->caption("addObject", "") %></th>
     <th><% $admin->caption("zoomChildren", "") %></th>
    </tr>
<%perl>
 foreach my $i ($start_record .. $last_record) {
     my $rec = $rs->record($i);
</%perl>

    <tr>
     <td>
      <a href="single.html?worldId=<% encode_entities($rec->field("id"))
	%>"><% encode_entities($rec->displayName()) %></a>
     </td>
% if ($admin->configValue("showProvider")) {
     <td>
      <% encode_entities($rec->field("serviceProvider")) %>
     </td>
% }
     <td>
% if (defined $user) {
<& /mc/link/add.mc, context => "list", worldId => $rec->field("id") &>
% }
     </td>
     <td>
<& /mc/link/zoom.mc, context => "list", worldId => $rec->field("id") &>
     </td>
    </tr>
% }
   </table>

   <% $pagingHTML %>

<%doc>
    foreach my $key (sort keys %ENV) {
	print "<li>$key = [", $ENV{$key}, "]<li>\n";
    }
</%doc>
