<%args>
$query => undef
$days => undef
$go => undef
$search => undef
$sort => undef
</%args>
<%perl>
if ($go) {
    my @targets = ();
    my $q = $m->notes('q');

    foreach my $key ($q->param()) {
	if ($key =~ s/^target_//) {
	    push @targets, $key;
	}
    }

    my $html = "<div id='mkwsRecords'";
    $html .= "\n\tautosearch='" . encode_entities($search) . "'";
    $html .= "\n\tsort='" . encode_entities($sort) . "'";
    if (@targets) {
	$html .= "\n\ttargets='pz:id~" . encode_entities(join('|', @targets)) . "'";
    }
    $html .= "\n>results will appear here</div>";

    print "<pre>", encode_entities($html), "</pre>\n";
    return;
}

my $fullquery = $m->comp("/mc/make-fullquery.mc", query => $query, days => $days);
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc", require => 1) or return;
my $rs;
eval {
    my $realm = $user->field("identityId");
    $rs = $admin->torus()->sortedRecords($realm, $fullquery, $user, 0, 50);
}; if ($@) {
    print $admin->exception2error($@);
    return;
}

my $n = $rs->alln();
</%perl>
   <h2>Create an auto-search widget</h2>
   <form>
    <p>
     Search term:
     <input type="text" name="search"/>
    </p>
    <p>
     Sort by:
     <select name="sort">
      <option value="relevance">Relevance</option>
      <option value="title:1">Title</option>
      <option value="date:0">Newest</option>
      <option value="date:1">Oldest</option>
     </select>
    </p>
    <p>Choose targets to include</p>
    <table class="list">
     <tr>
      <th>Target</th>
      <th>Sort</th>
      <th>Include?</th>
     </tr>
% foreach my $i (0 .. $n-1) {
% my $rec = $rs->record($i);
% my $sort = join(', ', map { s/^query-sort-//; $_ } grep(/^query-sort-/, split(/\s+/, $rec->field("capabilities"))));
     <tr>
      <td>
       <a href="single.html?id=<% encode_entities(uri_escape_utf8($rec->field("id")))
	%>"><% encode_entities($rec->displayName()) %></a>
      </td>
      <td>
       <% encode_entities($sort) %>
      </td>
      <td>
       <input type="checkbox" name="target_<% $rec->field("zurl") %>" value="1"/>
      </td>
     </tr>
% }
    </table>
    <p>
     <input type="submit" name="go" value="Go!"/>
    <p>
   </form>
