package Masterkey::Admin::ResultSet;

use strict;
use warnings;

sub new {
    my $class = shift();
    my($records, $alln, $myn, $count, $start, $facets, $cloud) = @_;
    die "no alln" if !defined $alln;

    return bless {
	records => $records,	
	alln => $alln,		# Total number of records found
	myn => $myn,		# Number of those records that are selected
	count => $count,	# Number of records actually returned
	start => $start,	# Zero-based index of first returned record
	facets => $facets,
	cloud => $cloud,
    }, $class;
}

### DEPRECATED -- Traverse records using record($i) up to alln() instead
sub records { my $this = shift(); return $this->_getOrSet("records", @_) }

sub alln { my $this = shift(); return $this->_getOrSet("alln", @_) }
sub myn { my $this = shift(); return $this->_getOrSet("myn", @_) }
sub count { my $this = shift(); return $this->_getOrSet("count", @_) }
sub start { my $this = shift(); return $this->_getOrSet("start", @_) }
sub facets { my $this = shift(); return $this->_getOrSet("facets", @_) }
sub cloud { my $this = shift(); return $this->_getOrSet("cloud", @_) }

sub record {
    my $this = shift();
    my($i) = @_;

    my $start = $this->start();
    die "start undefined" if !defined $start;
    die "record $i before start $start" if $i < $start;
    my $count = $this->count();
    die "count undefined" if !defined $count;
    die "record $i past end ${start}[$count]" if $i >= $start+$count;

    return $this->{records}->[$i-$start];
}


sub _getOrSet {
    my $this = shift();
    my($elem, $new) = @_;

    my $old = $this->{$elem};
    $this->{$elem} = $new if defined $new;
    return $old;
}


1;
