<%args>
$file => "/tmp/provider.csv"
$debug => 0
</%args>
<%once>
use Masterkey::Admin::Report;
use IO::File;
</%once>


<%perl>
my $merged = 1; # XXX
my $file_tmp = $file . ".tmp.$$";

warn "Re-generate '$file_tmp'\n" if $debug;
my $fh = new IO::File $file_tmp, "w";

if (!defined $fh) {
    die "open $file_tmp: $!\n";
}
	
$m->comp("/mc/setup.mc");
my $admin = $m->notes("admin");
my $user = $m->comp("/mc/utils/user.mc") or return;

# We are using a heuristic here to determine when we are at the
# consortium level: existing Torus2-based MKAdmin installations use
# the "admin.wizard" realm to hold consortium-level administrator
# records, but pre-Torus2 installations do not and future
# installations may not.  We will need to refine this heuristic.
my $consortiumLevel = ($user->field("realm") eq "admin.wizard");

my $report = new Masterkey::Admin::Report();

my $realm = $user->field("identityId");
my $torus = $consortiumLevel ? $report->gtorus() : $report->storus();
my $rs = $merged ? 
    $torus->sortedMerged($realm, undef, $user) :
    $torus->sortedRecords($realm, undef, $user);

my $hash;
foreach (my $i = 0; $i < $rs->alln(); $i++) {
    my $rec = $rs->record($i);

    my $publisher = $rec->field("serviceProvider") || "";
    my $name = $rec->displayName() || "";

    push @{ $hash->{$publisher}}, $name;
}

my %dup;
foreach my $key (sort keys %$hash) {
    print $fh qq/"$key",\n/;
    foreach my $name (sort @{$hash->{$key}}) {
        if (!exists $dup{$name}) {
            print $fh qq{,"$name"\n} ;
            $dup{$name} = 1;
        }
    }
}

$fh->close;
rename($file_tmp, $file) or die "rename $file_tmp -> $file: $!\n";

</%perl>
