<%args>
$facets
$cloud
$query
</%args>

<%perl>
my $admin = $m->notes("admin");
my $showFacets = $admin->conf("showFacets");
my $showTagCloud = $admin->conf("showTagCloud");

if ($showFacets || $showTagCloud) {
    # Finding the correct torus to load category ID->Name maps from is
    # awkward.  The torus is specified in the appropriate categories
    # tab's configuration, but to determine which tab that is, we need
    # to look at how this tab's configuration says to edit the
    # categories field.  If there is no such configuration, then we do
    # no mapping.
    my %categoryId2name;
    my $tab = $admin->conf("field.categories.editType");
    if ($tab) {
	$tab =~ s/.* //;
	#warn "getting category mapping from tab '$tab'";
	my $user = $m->comp("/mc/utils/user.mc", require => 1);
	my $sadmin = new Masterkey::Admin($tab);
	my $rs = $sadmin->torus()->records($user->field("identityId"));
	my $catList = $rs->records();
	foreach my $cat (@$catList) {
	    my $id = $cat->field("categoryId");
	    $categoryId2name{$id} = $cat->displayName();
	    #warn "mapped '$id' -> '", $categoryId2name{$id}, "'";
	}
    }

    my $f = "";
    if ($showFacets) {
	my %defs = (
	    # facetName     =>   Caption,            op,   max, mapFunction
	    serviceProvider => [ 'Service Provider', '==',  20, undef ],
	    categories      => [ 'Categories',       '=',   40, sub { $categoryId2name{$_[0]} || "[" . $_[0] . "]" } ],
	    opacVendor      => [ 'Opac Vendor',      '==',  10, undef ],
	    openAccess      => [ 'Open Access',      '==',  10, sub { $_[0] ? "Yes" : undef } ],
	    );
        $f .= "<hr>";
	my $facetList = $admin->conf("facetList");
	foreach my $facetName (split(/\|/, $facetList)) {
	    my($caption, $op, $defaultMax, $mapFunction);
	    my $def = $defs{$facetName};
	    if ($def) {
		($caption, $op, $defaultMax, $mapFunction) = @$def;
	    } else {
		$caption = $admin->conf("facet.$facetName.caption") || $facetName;
		$op = $admin->conf("facet.$facetName.op") || '==';
		$defaultMax = 10;
		# There is presently no way to configure a map function
	    }

	    $f .= ("<p>$caption</p>" .
		   $facets->{$facetName}->html_js(query => $query, cql_field => "$facetName$op",
						  max => $admin->conf("maxFacets.$facetName") || $defaultMax,
						  map_function => $mapFunction));
	}
    }

    if ($showTagCloud) {
        $f .= "<hr>" . $cloud->html_and_css_js(42); 
    }
    $f .= "<hr>";
</%perl>

<script type="text/javascript">
//<![CDATA[
        var facets = document.getElementById("facets");
        if (facets) {
            facets.innerHTML = '<% $f %>';
        }
//]]>
        </script>
% }

