<%args>
$field
$protected => 0
$record
$user
$context => undef
$seeBase => 0
</%args>
<%perl>
my $prefix = defined $context ? "$context." : "";
my $admin = $m->notes("admin");
my $q = $m->notes("q");
my $attrs = qq[class="editable"];
$attrs = qq[class="readonly" readonly="readonly"] if $protected;
$attrs .= qq[ id="input-$field"];
$attrs .= ' name="' . encode_entities($field) . '"';
# Propagate all JavaScript event properties
foreach my $key (keys %ARGS) {
    if ($key =~ /^on/) {
	my $val = encode_entities($ARGS{$key});
	$attrs .= " $key=\"$val\""
    }
}

my $isscan = 0;
my($options, $select) = (undef, undef);
my $editType = $admin->conf("field.$field.editType");
my $cmd;
if (defined $editType) {
    ($cmd, my $args) = split /\s+/, $editType, 2;
    if ($cmd eq "scan") {
	$isscan = 1;
    } elsif ($cmd eq "options" || $cmd eq "multiOptions") {
	$options = $args;
    } elsif ($cmd eq "select" || $cmd eq "multiSelect") {
	$select = $args;
    } elsif ($cmd eq "text") {
	# Do nothing -- fall through to default case
    } else {
	die "unknown editType '$editType'";
    }
}
my $value = utf8param($q, $field);

# I don't at all understand why this next line is needed -- surely
# when there is no "id" parameter in the URL query, $value should be
# undefined instead of empty? But it's empty, so this line fixes bug
# MKA-70.
$value = undef if $field eq 'id' && defined $value && $value eq '';

if (!defined $value && defined $record) {
	$value = $record->field($field, $seeBase ? undef : "override");
} elsif (!defined $value && !$isscan && defined $admin->conf("field.$field.clone")) {
	$value = $user->field($field);
}
my $height = $admin->conf("${prefix}field.$field.height");
</%perl>
% if (defined $options) {
<& input-options.mc, attrs => $attrs, value => $value, options => $options,
	multi => ($cmd eq "multiOptions") &>
% } elsif (defined $select) {
<& input-select.mc, field => $field, attrs => $attrs, record => $record, value => $value, select => $select,
	multi => ($cmd eq "multiSelect") &>
% } elsif ($height) {
       <textarea cols="46" rows="<% $height %>" <% $attrs %>><%
	encode_entities($value) %></textarea>
% } else {
% $attrs .= ' value="' . encode_entities($value) . '"' if defined $value;
% my $auto = $admin->conf("field.$field.autoFill");
% $attrs .= qq[ onChange="maybeFill(this, 'input-$auto')"] if defined $auto;
       <input type="text" size="40" <% $attrs %> />
% }
<%perl>
$m->comp("/mc/scan.mc", field => "$field") if $isscan;

my $help = $admin->conf("field.$field.help");
$m->comp("/mc/link/help.mc", field => "$field") if defined $help;
</%perl>
