#!/bin/sh
# Copyright (c) 2011-2012 IndexData ApS. http://indexdata.com
#
# cf-bisect - find by git binary search the change that break a connector 
#             in the CFWS API test
#
# git bisect start 
# git bisect start [<bad> [<good>...]

# git bisect good v2.10.1 
# git bisect bad  v2.12.1 
# git bisect run ~/proj/cf/bin/cf-bisect.sh
#
# e.g.:
# git bisect start v2.8.6 HEAD
# connector=/tmp/ebsco_eit.19.cf git bisect run ./engine/src/cf-bisect >& log.bisect
#
# for more details, see the git-bisect man page


# which connector to test
: ${connector="/var/lib/cf-repo/ebscousi/ebsco_eit.35.cf"}

set -e

if [ ! -e .git/config ]; then
   echo "You need to run this command from the toplevel of the working tree." >&2 
   exit 1
fi

# compile engine
cd engine/src
make distclean
make -j8

# start a local metaproxy
CF_BASE_PATH=`cd ../..; pwd` MP_PROG=../../../metaproxy/src/metaproxy ./mp-start.sh

ret=0
env CFWS_URL=http://localhost:9070/connector ../../cfrepo/bin/cfws-test.pl $connector || ret=1

# stop metaproxy and return status of cfws test
./mp-stop.sh

if [ $ret != 0 ]; then
   echo "TEST for connector $connector failed!"
   git log --pretty=oneline | head -1
fi
exit $ret

