#!/bin/sh
# Copyright (c) 2012 by Index Data ApS. http://indexdata.com
#
# cf-bootstrap-light.sh - build the engine repo in a sandbox and run full tests
#
# To install devel tools, see the list of tools on
# http://twiki.indexdata.dk/cgi-bin/twiki/view/ID/CFRepoInstallation

# fail on error
#set -e

dir=$(mktemp -d -t cf-bootstrap.XXXXXXXX)
cd $dir
logfile=$dir/cf.log

: ${make=make}
: ${make_opt="-s -j4"}
: ${debug=""}

# test a CF branch
: ${cf_branch=""}

# test a GIT ID on a branch
: ${cf_git_id=""}


# cross compiling flags for MacOS
case `uname` in
    FreeBSD ) 	make=gmake ;;	
esac

for prog in $(which cf-checkout.sh 2>/dev/null) \
	$HOME/indexdata/cf/bin/cf-checkout.sh  \
	$HOME/proj/cf/bin/cf-checkout.sh
do
   if test -x "$prog"; then
	prog=$prog
	break
   fi
done
if test -z $prog; then
   echo "cannot find cf-checkout script"
   exit 1
fi

test -n "$debug" && echo "start bootstraping in $dir"
$prog > $logfile 2>&1
cd cf

if [ -n "$cf_branch" ]; then
   cd $dir/cf
   git checkout -b $cf_branch origin/$cf_branch >> $logfile 2>&1
   if [ -n "$cf_git_id" ]; then
       git checkout $cf_git_id >> $logfile 2>&1
   fi
fi

YAZ_CONFIG=$(which yaz-config)
METAPROXY_CONFIG=$(which metaproxy-config)
MP_PROG=$(which metaproxy)
export YAZ_CONFIG METAPROXY_CONFIG MP_PROG

if make=$make make_opt="$make_opt" time make check >> $logfile 2>&1; then
    test -n "$debug" && echo "Ok"
    test -z "$debug" && rm -rf $dir
    exit 0
else
    echo "Failure, see $logfile"
    cat $logfile
    exit 1
fi

