#!/bin/sh
# Copyright (C) 2010-2014 by Index Data ApS. http://www.indexdata.com
#
# build the engine with the lastest Index Data tools from GIT repo
#

# fail on error
set -e

command=$1

cpu=$(/sbin/sysctl -a 2>/dev/null | egrep kernel.sched_domain.cpu.*.domain0.name | wc -l)
if [ $cpu -le 0 -o $cpu -gt 8 ]; then
    cpu=2
fi

# number of CPUs
: ${ncpu=$cpu}

# test a CF branch
: ${cf_branch=""}

# test a GIT ID on a branch
: ${cf_git_id=""}

# IndexData GIT repository prefix
git_repo=ssh://git.indexdata.com:222/home/git

nice="time nice -n10"
prefix=$(pwd)/opt
make=make

PATH=/bin:/usr/bin; export PATH

# OS specific compile flags
case `uname` in
    Linux )
	PKG_CONFIG_PATH=/usr/cf-xulrunner/lib/pkgconfig; export PKG_CONFIG_PATH
	if [ -e /etc/redhat-release ]; then
	   centos=`cat /etc/redhat-release `
	   PKG_CONFIG_PATH=/usr/cf-xulrunner/lib64/pkgconfig
	fi
	# outdated autoconf on centos5
	case $centos in
	    *5.8* ) PATH=/usr/local/bin:$PATH ;;
	esac
	;;
esac

###################################################
git_clone () {
    url="$1"
    repo=$(basename $url)

    if [ ! -d $repo ]; then
        git clone -q $url
    else
        ( cd $repo && git pull )
    fi
}

git_clone $git_repo/private/cf
git_clone $git_repo/pub/yaz
git_clone $git_repo/pub/yazpp
git_clone $git_repo/pub/metaproxy

dir=`pwd`
if [ -n "$cf_branch" ]; then
   cd "$dir/cf"
   git checkout -b $cf_branch origin/$cf_branch
   if [ -n "$cf_git_id" ]; then
       git checkout $cf_git_id
   fi
fi

cat <<EOF
LDFLAGS= 	$LDFLAGS
CFLAGS=  	$CFLAGS
CXXFLAGS= 	$CXXFLAGS
PATH=		$PATH
xulrunner_arch= $xulrunner_arch
ncpu=		$ncpu
PKG_CONFIG_PATH=$PKG_CONFIG_PATH

EOF

for software in yaz yazpp metaproxy
do
    echo "build >>> $software <<<"
    cd "$dir/$software"
    $nice ./buildconf.sh
    LDFLAGS="$LDFLAGS" CFLAGS="$CFLAGS" CXXFLAGS="$CXXFLAGS" $nice ./configure --prefix=$prefix
    $nice $make -j$ncpu INKSCAPE=true all

    if [ $software = "metaproxy" ]; then
	touch doc/multi.png
    fi

    case $command in
    	fullcheck | fulltest ) $make check;;
    esac

    $nice $make INKSCAPE=true install
done


cd "$dir/cf/engine/src"
$nice $make -j$ncpu YAZ_CONFIG=../../../yaz/yaz-config MP_CONFIG=../../../metaproxy/metaproxy-config

case $command in
    test | check | fullcheck | fulltest )
	cd "$dir/cf" && $make check ;;
    *) echo "You may run now: $ cd cf; $make check";;
esac
