#!/bin/sh
# Copyright (c) 2011-2012 IndexData ApS. http://indexdata.com
#
# cf-checkout.sh - checkout CF from GIT 
#
# examples:
#
# just checkout, create a ./cf directory
# $ cf-checkout.sh
#
# checkout from a local branch installation $HOME/proj/cf
#   cf_git_repo=$HOME/proj/cf cf-checkout
#
# use a b2.20 branch installation
#   cf_git_repo=$HOME/proj/cf-2.20 cf-checkout
#

set -e

: ${cf_branch=b2.26}
: ${cf_git_repo="ssh://git.indexdata.com:222/home/git/private/cf"}
git clone $cf_git_repo

checkout_dir=$(basename $cf_git_repo .git)
cd $checkout_dir
git config push.default current

echo ""
echo "You may run: "
echo "cd $checkout_dir; git checkout -b $cf_branch origin/$cf_branch"

