#!/bin/sh
#
# regression tests for CF unittests
#
# run from cf/engine/src
#
# a test runs ~5 seconds, which means 15_000 tests runs will run for 24hours
#
# 

: ${DEBUG=1}
for i in $(perl -e 'for(1 .. 5_000) { print "$_\n"}')
do 
    make unittest-silent > u.log 2>&1
    error=$?
    echo "xxx: $error :: $i :: $(date)"

    if [ $DEBUG -gt 0 -o $error -ne 0 ]; then 
	cat u.log
	cat unittests.log
    fi
    sleep 0.02
done

exit

############################################################
# example how to run 3 tests in parallel in a sandbox
#
#
cat <<EOF
list="1 2 3"
for i in $list;do (mkdir -p $i; cd $i; ~/indexdata/cf/bin/cf-build-devel.sh >& log && ( cd cf; rm -rf perf; make check >> log 2>&1;));done
for i in $list;do (mkdir -p $i; cd $i; cd cf/engine/src; \time env CF_DISPLAY_START=5${i}0 ~/indexdata/cf/bin/unitest-regression.sh >& b.log ) & done
wait

EOF

