var EXPORTED_SYMBOLS = ["core"];
Components.utils.import("resource://indexdata/util/Subject.js");
/**
 * Core values and functions needed in both the builder and engine outside
 * of any specific Connector instance.
**/
var core = new Subject ([
  // nsILocalFile for the main CF directory ie. CF_BASE_PATH
  'cfRootFile',
  'inBuilder',
  'platformVersion', // Xulrunner or Firefox
  'version', // CF version
]);
// We're only concerned about the major version
core.setPlatformVersion = function(pv) {
  if (typeof pv === 'number') core.set('plarformVersion', pv);
  else core.set('platformVersion', Number(pv.match(/^\d*/)[0]));
};
// Cached templates
core.templates = {};

core.idprefs = Components.classes["@mozilla.org/preferences-service;1"]
             .getService(Components.interfaces.nsIPrefService)
             .getBranch("indexdata.cf.");

core.set('inBuilder', true);

// Name of the last loaded connector
// Mostly used for debugging, so it may as well be a full file path
// or repo URL.
core.lastconnector = ""; // may be empty if not known
