var EXPORTED_SYMBOLS = ["Download"];
var Cc = Components.classes;
var Ci = Components.interfaces;
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/textHelper.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Download = function () { this.conf = {}; };

Download.prototype = new Step();
Download.prototype.constructor = Download;
Download.prototype.init = function(task) {};

Download.prototype.draw = function(surface) {
  xulHelper.jsonPathField(surface, this, this.conf, "urljp", "URL to retrieve:",
    {path:"$.temp", key:"url"},
    {rwmode:"r", singlevalue:true, constantallowed:true }  );
  xmlHelper.appendNode(surface, "caption", "Path and filename:");
  xulHelper.jsonPathField(surface, this, this.conf, "filenamejp", null,
    {path:"$.temp", key:"filename", append:jsonPathHelper.REPLACE},
    {rwmode:"w"} );
    
};

Download.prototype.run = function (task) {
  var url = jsonPathHelper.getFirst(this.conf.urljp, task.data);
  if (!url) throw new StepError("Source URL not specified");
  // TODO: allow path override via environment variable
  var filename = '/tmp/';
  // generate an unlikely-to-collide filename
  filename += new Date().getTime() + '-' + textHelper.randString(8);

  var ioserv = Cc["@mozilla.org/network/io-service;1"].getService(Ci.nsIIOService);
  var channel = ioserv.newChannel(url, 0, null);
  var stream = channel.open();
  if (channel instanceof Ci.nsIHttpChannel) {
    if (channel.responseStatus != 200) {
      throw new StepError("HTTP error downloading file: " + channel.responseStatus);
    }
  } else {
    throw new StepError("The Download step only supports HTTP");
  }
  var bstream = Cc["@mozilla.org/binaryinputstream;1"]
    .createInstance(Ci.nsIBinaryInputStream);
  bstream.setInputStream(stream);
  var size = 0;
  var file_data = "";
  while(size = bstream.available()) {
    // TODO: we could be writing this as it comes in
    file_data += bstream.readBytes(size);
  }
  var aFile = Cc["@mozilla.org/file/local;1"].createInstance(Ci.nsILocalFile);
  aFile.initWithPath(filename);
  aFile.createUnique(Ci.nsIFile.NORMAL_FILE_TYPE, 0644);
  var stream = Cc["@mozilla.org/network/safe-file-output-stream;1"]
    .createInstance(Ci.nsIFileOutputStream);
  stream.init(aFile, 0x04 | 0x08 | 0x20, 0600, 0); // write, create, truncate
  stream.write(file_data, file_data.length);
  if (stream instanceof Ci.nsISafeOutputStream) stream.finish();
  else stream.close();
  jsonPathHelper.set(this.conf.filenamejp, [filename], task.data);
};
Download.prototype.getClassName = function () { return "Download"; };
Download.prototype.getDisplayName = function () { return "Download"; };
Download.prototype.getDescription = function () {
  return "Download file to a specified path ";
};
Download.prototype.getVersion = function () {
  return "1.0";
};
Download.prototype.getUsedArgs = function () {
  if (this.conf.urljp && this.conf.urljp.path === "$.input")
    return [this.conf.urljp.key];
  else
    return [];
};
Download.prototype.renderArgs = function () {
  if (!this.conf.urljp) return "";
  else return this.conf.urljp.path + "." + this.conf.urljp.key;
};
