var EXPORTED_SYMBOLS = ["Event"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/waitForLoad.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var Event = function () {
  this.events = {
    mouse: {
      types: ["click", "dblclick", "mousedown", "mouseup", "mouseover", "mousemove", "mouseout"],
      params: ['detail', 'screenX', 'screenY', 'clientX', 'clientY', 'ctrlKey', 'altKey', 'shiftKey', 'metaKey', 'button']
    },
    key: {
      types: ['keypress', 'keydown', 'keyup'],
      params: ['ctrlKey', 'altKey', 'shiftKey', 'metaKey', 'keyCode', 'charCode']
    },
    html: {
      types: ['abort', 'beforeunload', 'change', 'error', 'load', 'reset', 'resize', 'scroll', 'select', 'submit', 'unload'],
      params: []
    },
    ui: {
      types: ['DOMActivate', 'DOMFocusIn', 'DOMFocusOut', 'blur', 'focus'],
      params: ['detail']
    }
  }; 

  this.conf = {};
  this.conf['target'] = "";
  this.conf['wait'] = {};
  this.conf['wait']['active'] = false;
  this.conf['category'] = "html";
  this.conf['type'] = "reset";
  this.conf['canBubble'] = true;
  this.conf['cancelable'] = true;

  // potentially optional
  this.conf['detail'] = 0;
  this.conf['screenX'] = 0;
  this.conf['screenY'] = 0;
  this.conf['clientX'] = 0;
  this.conf['clientY'] = 0;
  this.conf['ctrlKey'] = false;
  this.conf['altKey'] = false;
  this.conf['shiftKey'] = false;
  this.conf['metaKey'] = false;
  this.conf['keyCode'] = 0;
  this.conf['charCode'] = 0;
  this.conf['button'] = 0;

};

Event.prototype = new Step();
Event.prototype.constructor = Event;

Event.prototype.init = function() {};

Event.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  var context = this;
  var isDisabled = function (evParam) {
    return context.events[context.conf.category].params.indexOf(evParam) === -1;
  };
  let vbox = xmlHelper.appendNode(surface, "vbox", null, null, null);

  let hbox = xmlHelper.appendNode(vbox, "hbox", null, {align:"center"}, null);
  xmlHelper.appendNode(hbox, "caption", "Target element xpath: ", null, null);
  xulHelper.singleNodeField(hbox, this, 'target');

  hbox = xmlHelper.appendNode(vbox, "hbox", null, {align:"center"}, null);
  xmlHelper.appendNode(hbox, "caption", "Category: ", null, null);
  var catSelect = xulHelper.arraySelectField(hbox, this, 'category', Object.keys(this.events));
  xmlHelper.appendNode(hbox, "caption", "Event type: ", null, null);
  xulHelper.arraySelectField(hbox, this, 'type', this.events[this.conf.category].types);
  xulHelper.inputField(hbox, this, 'detail', "Detail: ", '70', {'width':'40'}).disabled = isDisabled('detail');

  hbox = xmlHelper.appendNode(vbox, "hbox", null, {align:"center"}, null);
  xulHelper.inputField(hbox, this, 'screenX', "Screen X: ", '70', {'width':'40'}).disabled = isDisabled('screenX');
  xulHelper.inputField(hbox, this, 'screenY', "Screen Y: ", '70', {'width':'40'}).disabled = isDisabled('screenY');
  xulHelper.inputField(hbox, this, 'clientX', "Client X: ", '70', {'width':'40'}).disabled = isDisabled('clientX');
  xulHelper.inputField(hbox, this, 'clientY', "Client Y: ", '70', {'width':'40'}).disabled = isDisabled('clientY');
  xmlHelper.appendNode(hbox, "caption", "Mouse button: ", null, null).disabled = isDisabled('button');

  hbox = xmlHelper.appendNode(vbox, "hbox", null, {align:"center"}, null);
  xulHelper.inputField(hbox, this, 'keyCode', "Key code: ", '70', {'width':'40'}).disabled = isDisabled('keyCode');
  xulHelper.inputField(hbox, this, 'charCode', "Unicode: ", '70', {'width':'40'}).disabled = isDisabled('charCode');

  hbox = xmlHelper.appendNode(vbox, "hbox", null, {align:"center"}, null);
  xulHelper.checkbox(hbox, this, 'ctrlKey', "ctrl").disabled = isDisabled('ctrlKey');
  xulHelper.checkbox(hbox, this, 'altKey', "alt").disabled = isDisabled('altKey');
  xulHelper.checkbox(hbox, this, 'shiftKey', "shift").disabled = isDisabled('shiftKey');
  xulHelper.checkbox(hbox, this, 'metaKey', "meta").disabled = isDisabled('metaKey');
  xulHelper.checkbox(hbox, this, 'canBubble', "Can bubble?");
  xulHelper.checkbox(hbox, this, 'cancelable', "Cancelable?");

  waitForLoad.stepXul(surface, this.conf['wait']);
  
  catSelect.addEventListener("command", function(e) { context.draw(surface) }, false);
};

Event.prototype.run = function (task) {
  this.task.connector.clearPageOverride();
  waitForLoad.wait(task, this.conf.wait, this);  
  var pageDoc = this.getPageDoc();
  var pageWin = this.getPageWindow();
  let nodeSpec = jsonPathHelper.inlineReplaceNodeSpec(this.conf.target, task.data);
  let target = xmlHelper.getElementByNodeSpec(pageDoc, nodeSpec);
  if (target === null) {
    throw new StepError("Target element not found.");
  }
  var event;
  switch(this.conf.category) {
  case 'mouse':
    event = pageDoc.createEvent("MouseEvents");
    event.initMouseEvent(
      this.conf['type'],
      this.conf['canBubble'],
      this.conf['cancelable'],
      pageDoc.defaultView,
      this.conf['detail'],
      this.conf['screenX'],
      this.conf['screenY'],
      this.conf['clientX'],
      this.conf['clientY'],
      this.conf['ctrlKey'],
      this.conf['altKey'],
      this.conf['shiftKey'],
      this.conf['metaKey'],
      this.conf['button'],
      null);
    break;
  case 'key':
    event = pageDoc.createEvent("KeyboardEvent");
    event.initKeyEvent(
      this.conf['type'],
      this.conf['canBubble'],
      this.conf['cancelable'],
      pageDoc.defaultView,
      this.conf['ctrlKey'],
      this.conf['altKey'],
      this.conf['shiftKey'],
      this.conf['metaKey'],
      this.conf['keyCode'],
      this.conf['charCode'],
      null);
    break;
  case 'html':
    event = pageDoc.createEvent("HTMLEvents");
    event.initEvent(
      this.conf['type'],
      this.conf['canBubble'],
      this.conf['cancelable']
    );
    break;
  case 'ui':
    event = pageDoc.createEvent("UIEvents");
    event.initUIEvent(
      this.conf['type'],
      this.conf['canBubble'],
      this.conf['cancelable'],
      pageDoc.defaultView,
      this.conf['detail']
    );
    break;
  }
  task.info("sending " + this.conf['type'] + " event to " + this.conf.target.xpath, this);
  var ret = target.dispatchEvent(event);
  if (!ret) task.debug("Dispatched event may have been prevented.");
};

Event.prototype.getClassName = function () {
  return "Event";
};

Event.prototype.getDisplayName = function () {
  return "Event";
};
Event.prototype.getDescription = function () {
  return "Sends an event to an element.";
};
Event.prototype.getVersion = function () {
  return "1.0";
};

Event.prototype.upgrade = function (confVer, curVer, conf) { 
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.2) {
    var oldwait = conf['wait'];
    conf['wait'] = {};
    conf['wait']['active'] = oldwait;
  }
  return true;
};

Event.prototype.renderArgs = function () {
  return this.conf.type + "->" + (this.conf.target.xpath?this.conf.target.xpath:"");
}
