var EXPORTED_SYMBOLS = ["Map"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import("resource://indexdata/util/logging.js");
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');
Components.utils.import('resource://indexdata/runtime/Task.js');

var logger = logging.getLogger();

var Map = function () {
  this.conf = {};
  this.conf.maps = [];
  this.conf.in = {};
  this.conf.out = {append:jsonPathHelper.REPLACE};
  this.conf.default = "";  // noMatchDefault
  this.conf.emptyDefault = "";
  this.conf.noMatchFail = true;
  this.conf.emptyFail = false;
};
Map.prototype = new Step();
Map.prototype.constructor = Map;
Map.prototype.init = function() {};

Map.prototype.draw = function(surface) {
  Components.utils.import('resource://indexdata/ui/taskPane.js');
  Components.utils.import('resource://indexdata/ui/app.js');
  var context = this;

  // Data
  var varbox = xmlHelper.appendNode(surface, "vbox", null, { });
  xulHelper.jsonPathMapField(varbox, this, "in", "out");

  // Controls
  var controls = xmlHelper.appendNode(surface, "hbox", null, { align: "center" });
  var emptyDefaultInput = xulHelper.inputField(controls, this, "emptyDefault", "If empty", null, { flex:1 });
  var emptyFailCheck = xulHelper.checkbox(controls, this, "emptyFail", "Fail?");
  xmlHelper.appendNode(controls, "spacer", null, { flex: "1" }, null);
  var noMatchDefaultInput = xulHelper.inputField(controls, this, "default", "Default", null, { flex:1 });
  var noMatchFailCheck = xulHelper.checkbox(controls, this, "noMatchFail", "Fail (no match)?");
  xmlHelper.appendNode(controls, "spacer", null, { flex: "1" }, null);
  var addButton = xmlHelper.appendNode(controls, "button", null, {"label": "Add map"}, null);

  // Map
  var mapBox = xmlHelper.appendNode(surface, "vbox");
  var buttonBox = xmlHelper.appendNode(surface, "hbox");
  logger.debug("Map: init: " + context.conf.maps.length );
  if ( context.conf.maps.length != 0)
    buttonBox.hidden = true;

  var pointButton = xmlHelper.appendNode(buttonBox, "button", null,
             {"label": "Get values from page"}, null);
  var dbButton = xmlHelper.appendNode(buttonBox, "button", null,
             {"label": "Get values from databases"}, null);

  var templ = this.task.getTemplate();
  for ( var d in templ.properties.mapDefaults ) {
    var def = templ.properties.mapDefaults[d];
    logger.debug("Doing preset button " + JSON.stringify(def) );
    var defBut = xmlHelper.appendNode(buttonBox, "button", null,
             {"label": def.label }, null);
    defBut.defaultIndex = d;
    defBut.addEventListener("click", function(e) {
        var thisdef = templ.properties.mapDefaults[ this.defaultIndex ];
        logger.debug("Def button " + thisdef.label + " clicked");
        xmlHelper.emptyChildren(mapBox);
        if ( typeof(thisdef.inputpath) == "string" && ! context.conf.in.path )
          context.conf.in.path = thisdef.inputpath;
        if ( typeof(thisdef.inputkey) == "string" && ! context.conf.in.key )
          context.conf.in.key = thisdef.inputkey;
        if ( typeof(thisdef.outputpath) == "string" && ! context.conf.out.path )
          context.conf.out.path = thisdef.outputpath;
        if ( typeof(thisdef.outputkey) == "string" && ! context.conf.out.key )
          context.conf.out.key = thisdef.outputkey;
        if ( typeof(thisdef.emptyDefault) == "string"  ) {
          emptyDefaultInput.cf_setValue(thisdef.emptyDefault);
        }
        if ( typeof(thisdef.emptyFail) == "boolean" ) {
           emptyFailCheck.cf_setValue(thisdef.emptyFail);
        }
        if ( typeof(thisdef.noMatchDefault) == "string" ) {
          noMatchDefaultInput.cf_setValue(thisdef.noMatchDefault);
        }
        if ( typeof(thisdef.noMatchFail) == "boolean" ) {
          noMatchFailCheck.cf_setValue(thisdef.noMatchFail);
        }
        //logger.debug("Adding maps " + JSON.stringify(thisdef.maps) );
        for ( var m in thisdef.maps ) {
          //logger.debug("Adding map " + m + ":" + JSON.stringify(thisdef.maps[m]) );
          addMap( thisdef.maps[m] );
        }
        saveMaps();
        xmlHelper.emptyChildren(varbox);
        xulHelper.jsonPathMapField(varbox, context, "in", "out");
        taskPane.refreshSteps();
      },false);
  }


  var rmMap = function (e) {
    var hbox = e.target.parentNode;
    hbox.parentNode.removeChild(hbox);
  };

  var saveMaps = function () {
    context.conf.maps = [];
    for (var i = 0; i < mapBox.children.length; i++) {
      let cur = mapBox.children[i];
      let from = cur.children[0];
      let to = cur.children[2];
      if (from.value)
        context.conf.maps.push({in:from.value, out:to.value});
    }
    logger.debug("Map: checkButtons: " + context.conf.maps.length );
    if ( context.conf.maps && context.conf.maps.length > 0 )
      buttonBox.hidden = true;
    else
      buttonBox.hidden = false;
  };

  var addMap = function (map) {
    if (map) {
      var mapIn = map.in || "";
      var mapOut = map.out || "";
    } else mapIn = mapOut = "";

    let fieldBox = xmlHelper.appendNode(mapBox, "hbox", null, {align: "center"});
    xmlHelper.appendNode(fieldBox, "textbox", null, {flex:"1", value: mapIn} , null);
    xmlHelper.appendNode(fieldBox, "image", null, {src: "chrome://cfbuilder/content/icons/go-next.png"}, null);
    xmlHelper.appendNode(fieldBox, "textbox", null, {flex:"1", value: mapOut}, null);
    let rm = xmlHelper.appendNode(fieldBox, "image", null, {src: "chrome://cfbuilder/content/icons/window-close.png"}, null);
    rm.addEventListener("click", function(e) { rmMap(e); saveMaps(); }, false);
    fieldBox.addEventListener("mouseover", function(e) {
      fieldBox.oldstyle = fieldBox.style;
      fieldBox.setAttribute("style",
                "background-color:#777777; moz-appearance: none");
    }, false);
    fieldBox.addEventListener("mouseout", function(e) {
      if ( fieldBox.oldstyle )
        fieldBox.setAttribute("style",fieldBox.oldstyle);
    }, false);
  };

  var loadMaps = function () {
    var maps = context.conf.maps;
    var loaded = false;
    for (var i = 0; i < maps.length; i++) {
      addMap(maps[i]);
      loaded = true;
    }
    return loaded;
  };

  // Start with a blank map if there isn't one
  if (!loadMaps()) {
    addMap();
  }

  addButton.addEventListener("command", function(e) { addMap(); }, false);
  mapBox.addEventListener("input", function(e) { saveMaps(); }, false);

  // Try to guess a value to map from, based on the display string and
  // the guesses in the task template
  var regexcache = {}; // cache the regular expressions we need in the loop
  var guessmap = function ( disp ) {
    for ( var g in templ.properties.mapGuesses ) {
      var guess = templ.properties.mapGuesses[g];
      var patt = regexcache[ guess.regex ];
      if ( !patt ) {
        patt=new RegExp(guess.regex,"i"); 
        regexcache[ guess.regex ] = patt;
        logger.debug("Caching regex " + guess.regex );
      }
      if ( patt.test(disp) ) {
        logger.debug("map guess for '" + disp + "' " +
           "matches '" + guess.regex +"' " +
           "guessing '" + guess.value + "'" );
        return guess.value;
      }
    }
  }; // guessmap

  // A helper to find radio buttons inside the node.
  // Finds also checkboxes
  var findradios = function(node) {
    var rl = [];
    if ( node ) {
      logger.debug("findradio: " + node.localName );
      if (node.localName == "input" &&
          (node.type == "radio" || node.type == "checkbox") ) {
        var disp = guessmap( node.value );
        if ( !disp )
          disp = node.value + " ###";
        var hit = { in: disp, out: node.value };
        rl.push(hit);  // TODO - Get the display text right
      }
      var c = findradios(node.firstChild);
      rl = rl.concat(c);
      var s = findradios(node.nextSibling);
      rl = rl.concat(s);
    }
    return rl;
  }; // findradios

  dbButton.addEventListener("click", function() { 
    context.conf.in.path = "$.input";
    context.conf.in.key = "database";
    context.conf.out.path = "$.session";
    context.conf.out.key = "db";

    var subdbs = app.connector.metaData["subdb"].split(/,\s*/);
    xmlHelper.emptyChildren(mapBox);
    for (let i=0; i<subdbs.length; i++) {
      addMap( { in: subdbs[i], out: ""} );
    }
    saveMaps();
    xmlHelper.emptyChildren(varbox);
    xulHelper.jsonPathMapField(varbox, context, "in", "out");
    taskPane.refreshSteps();
    logger.debug("Database count: " + subdbs.length);
  }, false); //database

  pointButton.addEventListener("click", function(e) {
    app.newHl(context.getPageDoc(), function() {
        var node = this;
        logger.debug("HL click: " + typeof(node) );
        //for ( var f in node )
        //  if (typeof(node[f]) != "function" )
        //    logger.debug("node." + f + ": " + node[f] );
        if ( node.localName.match(/SELECT/i) ) {
          app.highlighter.destroy();
          xmlHelper.emptyChildren(mapBox);
          var opts = node.options;
          logger.debug("Got a select with " + opts.length + " items");
          for ( var i = 0; i< opts.length; i++ ) {
            if ( opts.item(i) ) { // should always be, but coding defensive
              var item = opts.item(i);
              var mapfrom = guessmap(item.text);
              if ( !mapfrom )
                mapfrom = "" + (i+1) + ": " + item.text + " ###";
              addMap( { in: mapfrom,
                    out: item.value} );
            }
          } // options loop
          saveMaps();
        } else { // not a select, look for radio buttons
          var radios = findradios(node);
          if ( radios.length > 0  ) {
            app.highlighter.destroy();
            xmlHelper.emptyChildren(mapBox);
            for ( var i = 0; i<radios.length; i++ ) {
              addMap( radios[i] );
            }
            saveMaps();
          }
        }
        return false;
      } ); // highlighter
    }, false);
};

Map.prototype.run = function (task) {
  var conf = this.conf;
  var maps = conf.maps;

  if (!conf.in)
    throw new StepError("Missing source.");
  if (!conf.out)
    throw new StepError("Missing destination.");

  jsonPathHelper.mapElements(conf.in, conf.out, function (value) {
    // Empty?
    if (!value) {
      if (conf.emptyFail) {
        throw new StepError("Empty source in map set to fail on empty.");
      } else if (conf.emptyDefault) {
        return jsonPathHelper.inlineReplace(conf.emptyDefault, task.data);
      }
      return undefined; // This used not to be there, causing bug CP-3200
        // The changed behavior is compensated for in the upgrade function
    }

    // Map
    for (var i = 0; i < maps.length; i++) {
      let map = maps[i];
      if (value === map.in) {
        // return map.out;
        return jsonPathHelper.inlineReplace(map.out, task.data);
      }
    }

    // No match
    if (conf.noMatchFail) {
      throw new StepError("Value '" + value + "' not found in map");
    } else if (conf.default) {
      return jsonPathHelper.inlineReplace(conf.default, task.data);
    } else return undefined;
  }, task.data);
};



Map.prototype.getClassName = function () {
  return "Map";
};

Map.prototype.getDisplayName = function () {
  return "Map";
};

Map.prototype.getDescription = function () {
  return "Map an input to an output based on a list of paired values.";
};

Map.prototype.getVersion = function () {
  //return "1.1";  // 1.1 fixed a bug with empty values in empty-default
  return "2.0";  // 2.0 adds $.variable expansion to mapped values
};

Map.prototype.getUsedArgs = function () {
  if (this.conf.in.path === "$.input")
    return [this.conf.in.key];
};

Map.prototype.capabilityFlagDefault = function ( flag ) {
  //dump("checking query-and, conf = " + JSON.stringify(this.conf) + "\n");
  var used = this.getUsedArgs();
  for ( var a in used ) {
    if ( flag == "index-" + a )
      return true;
  }
  if ( this.conf.in.path != "$.output" ) {
    if ( this.conf.in.key == "field" ) {
      for ( var i=0; i<this.conf.maps.length; i++)
        if ( flag == "index-" + this.conf.maps[i].in )
          return true;
    } // field
    if ( this.conf.in.key == "op" ) {
      for ( var i=0; i<this.conf.maps.length; i++)
        if ( flag == "query-" + this.conf.maps[i].in )
          return true;
    } // field
  }
  if ( this.conf.in.path == "$.input" && this.conf.in.key == "sortkey" ) {
    if ( flag == "query-sort" )
      return true; // the unspecified query-sort flag
    for ( var i=0; i<this.conf.maps.length; i++) 
      if ( flag == "query-sort-" + this.conf.maps[i].in )
        return true; // specific one like query-sort-author
  }
  return null;
}

Map.prototype.renderArgs = function () {
  return this.conf.in.key + " -> " + this.conf.out.key;
};

Map.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;

  if (confVer < 0.1) {
    conf.emptyDefault = "";
    conf.emptyFail = false;
  }

  if (confVer < 1.1) {
    // In 1.0 we had a bug with mapping empty values. The fix changed
    // behavior, so this resets the settings so that the old behavior
    // is retained. See bug CP-3200
    if ( !conf.emptyFail && !conf.emptyDefault ) {
      // In this case, the code used to fall through to the matching,
      // never find anything, and use the default/fail settings from there.
      // Now it will not fall through, so we copy the settings over
      conf.emptyDefault = conf.default;
      conf.emptyFail = conf.noMatchFail;
    }
  } 
  
};

