var EXPORTED_SYMBOLS = ["NavTo"];
Components.utils.import('resource://indexdata/runtime/core.js');
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/waitForLoad.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/htmlHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();

var NavTo = function () {
  this.conf = {};
  this.conf['wait'] = {};
  this.conf['wait']['active'] = true;
  this.conf['rawxml'] = false;
  this.conf['hashonly'] = false;
  this.conf['jp'] = { path:"", key:"" };
};

NavTo.prototype = new Step();
NavTo.prototype.constructor = NavTo;

NavTo.prototype.init = function(task) { };

NavTo.prototype.draw = function(surface) {
  
  var context = this;

  var hbox = xmlHelper.appendNode(surface, "hbox");

  var jpField = xulHelper.jsonPathField(hbox, this, this.conf,
        "jp", "URL", null,
        { rwmode:"r", singlevalue: true,
          constantallowed: true,  expandvariables: true,
          constantbuttons: { label:"Current page", value: context.getPageDoc().URL },
        } );

  var wait = waitForLoad.stepXul(surface, this.conf['wait']);

  if (this.conf.rawxml === true) {
    xulHelper.checkbox(surface, this, "rawxml",
      "Load raw XML  (Deprecated - use Httpclient instead!)", null);
  }

  var hashcheck = xulHelper.checkbox(surface, this, "hashonly", 
                           "Only set the hash component, not the whole URL",
                           { tooltiptext: "Sets only the part of the URL after a '#'," +
                             "As in \nhttp://foo.com/page/#THIS-IS-THE-HASH" } );
  
};

NavTo.prototype.processConf = function () {
  //this.task.debug("NavTo.processConf calculating usedArgs");
  this.conf.usedArgs = jsonPathHelper.usedArgs(this);
  return;
}

NavTo.prototype.getUrl = function (task) {
    var url = jsonPathHelper.getFirst(this.conf.jp, task.data);
    if (!url) throw new StepError("URL not found in: " +
          jsonPathHelper.displayString(this.conf.jp,true)  );
      // yes, that normally displays nothing much, but may catch strange values
      // that sneak in...
/*
    if ( this.conf.jp.useconstant ) {
      // TODO - When JsonPath can do the inlineReplace, use that
      // but for now, to be backwards compatible, we have to be careful
      // and only replace when in constant mode.
      url = jsonPathHelper.inlineReplace(url, task.data);
    }
*/    
    return url;
};

NavTo.prototype.getRawXml = function(task) {
    var url=this.getUrl(task);
    task.debug("Getting rawurl from " + url );
    if (!core.inBuilder) {
        var dom = xmlHelper.fetchDoc( url, false, false );
        this.task.connector.setPageOverride(dom,url);
        task.debug("Got it");
        return;
    }
    // Inside the builder, we need to do a lot more to get a
    // a decent page to display. Just getting it to blank is a mess,
    // as pageload is supposed to be asynchronous.
    var context = this;
    var event = "DOMContentLoaded";
    var status = 0; // 0=not started, 1=loading, 2=done

    var eventhandler = function () { // This gets called once we have a blank page
        task.debug("event: " + event );
        try {
            task.connector.getPageWindow().
                removeEventListener(event, eventhandler, false);
            var doc = task.connector.getRealPageDoc();
            doc.body.innerHTML = "Loading raw XML from " +
            "<a href=\"" + url +"\" >" + url + "</a> <p/>\n";
            status = 1;
            //task.debug("Url: " + typeof(url) + " = " + url );
            //doc.body.innerHTML += "<p/><b>A1</b> "+ typeof(url) + "<br/>\n";
            //doc.body.innerHTML += "<p/><b>A</b>"
            //   + url.replace(/:/,":::") +"<br/>\n";
            var dom = xmlHelper.fetchDoc( url, false, false );
            //doc.body.innerHTML += "<p/><b>B</b><br/>\n";
            task.connector.setPageOverride(dom,url);
            task.debug("Loaded " + url);
            doc.body.innerHTML += "<p/><b>OK</b>\n";
            status = 2;
            task.debug("Looking at display doc\n");
            task.debug("" + doc.body );
            htmlHelper.renderXml( dom, doc, doc.body)
        } catch(e) {
            task.debug("GetRawXml caught an exception: " + e );
            doc.body.innerHTML += "<p/><b>FAIL</b><br/>" + e + "\n";
            if ( e.fileName && e.lineNumber )
              doc.body.innerHTML += e.fileName + ":" + e.lineNumber + "<br/>\n";
        }
        task.debug("Resuming task");
        task.resume();
    }; // onshow;

    // If we time out, the loading of about:blank failed,
    // or (much more likely), fetching the raw XML took
    // too long.
    var interruptcallback = function() {
        task.debug("in task interrupt function. st=" + status);
        if ( status == 2)
            return true;
        task.warn("Timed out waiting for raw XML from " + url);
        return false;
    }
    task.debug("About to blank the page");
    task.connector.getPageWindow().
        addEventListener(event, eventhandler, false);
    task.interrupt(30000,interruptcallback);  // 30 secs
    this.getPageDoc().location = "about:blank";
};

NavTo.prototype.run = function (task) {
  this.task.connector.clearPageOverride();
  if ( this.conf.rawxml ) {
      task.warn("Nav_to using RAW XML mode, which is deprecated!");
      this.getRawXml(task);
      return;
  }
  waitForLoad.wait(task, this.conf.wait, this);
  let doc = this.getPageDoc();
  let url = this.getUrl(task);
  if (this.conf.hashonly === true) {
    task.info("Changing hash to " + url, this);
    doc.location.hash = url;
  } else {
    task.info("Changing location to " + url, this);
    doc.location = url;
  }
};

NavTo.prototype.getUsedArgs = function () {
  return jsonPathHelper.usedArgs(this);
};

NavTo.prototype.getClassName = function () {
  return "NavTo";
};

NavTo.prototype.getDisplayName = function () {
  return "Go to URL";
};

NavTo.prototype.getDescription = function () {
  return "Navigates to a specified web-site address.";
};

NavTo.prototype.getVersion = function () {
  return "5.1";
};

NavTo.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.5) {
    conf['wait'] = {};
    conf['wait']['active'] = true;
  }
  if (confVer < 0.7) {
    // param can be an empty string, maybe other falsy values
    if (this.conf['param']) {
      if (this.conf['param'] !== "Constant address") {
        this.conf['jp'] = {path: "$.input", key: conf['param']};
        if (this.conf.url) delete this.conf.url;
      }
      delete this.conf['param'];
    }
  }
  if (confVer < 2.0) {
    this.processConf();
  }
  if (confVer < 3.0) {
    if (!this.conf.url) this.conf.usejp = true;
    else this.conf.usejp = false;
  }
  if (confVer < 5.1) { // upgrade to constants in the JsonPath
    logger.debug("NavTo upgrade " + confVer + " -> " + curVer );
    logger.debug(" this=" + JSON.stringify(this.conf) );
    if ( ! this.conf.jp )
      this.conf.jp = {};
    this.conf.jp.useconstant = ! this.conf.usejp;
    this.conf.jp.constantvalue = this.conf.url;
    if ( typeof(this.conf.jp.constantvalue) == "string" &&
         this.conf.jp.constantvalue.match( /\{\$./ ) ) {
      this.conf.jp.expandvariables = true;
    }
    this.conf.url = undefined;
    this.conf.usejp = undefined;
    logger.debug(" done=" + JSON.stringify(this.conf) );
  }
  return true;
};


NavTo.prototype.renderArgs = function () {
  return jsonPathHelper.displayString(this.conf['jp'],true);
};


NavTo.prototype.capabilityFlagDefault = function (flag) {
    if (this.task.name === "init" && flag.substring(0, 5) == "init-") {
	this.processConf(); // Refresh usedArgs
	var usedArgs = this.conf.usedArgs;
	//this.task.debug("nav_to init flag '" + flag + "' within init task: compare with " + usedArgs.length + " used args: " + JSON.stringify(usedArgs));
	for (var i = 0; i < usedArgs.length; i++) {
	    if (usedArgs[i] === flag.substring(5)) {
		//this.task.debug("nav_to init flag '" + flag + "' true for arg " + i + " of " + usedArgs.length);
		return true;
	    }
	}
    }

    // Pass up to the superclass's default implementation
    return Step.prototype.capabilityFlagDefault.call(this, flag);
}
