var EXPORTED_SYMBOLS = ["NormalizeUrl"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();

var NormalizeUrl = function () {
  this.conf = {
    in: {path:"$.output.results[*]", key:"url"},
    out: {path:"$.output.results[*]", key:"url"},
    do_url: true,
    do_thumburl: true,
    do_permalink: true,
    do_fulltexturl: true,
    do_custom: false,
  };
};
NormalizeUrl.prototype = new Step();
NormalizeUrl.prototype.constructor = NormalizeUrl;;

NormalizeUrl.prototype.init = function() {};

NormalizeUrl.prototype.draw = function(surface) {
  var context = this;

  var vbox1 = xmlHelper.appendNode(surface, "vbox", null,
                { flex: 1, pack: "top", align: "left" });

  var cbox = xmlHelper.appendNode(vbox1, "hbox", null,
                { flex: 1, pack: "baseline", align: "left" });
  xulHelper.captionField(cbox, "Normalize these", null );
  xulHelper.labelField(cbox, "in $.output.results[*]: ", null );
  xulHelper.checkbox(cbox, context, "do_url", "url" );
  xulHelper.checkbox(cbox, context, "do_thumburl", "thumburl" );
  xulHelper.checkbox(cbox, context, "do_fulltexturl", "fulltexturl" );
  xulHelper.checkbox(cbox, context, "do_permalink", "permalink" );
  
  xulHelper.checkbox(vbox1, context, "do_custom", "Normalize custom field" );

  xulHelper.jsonPathMapField(vbox1, this, "in", "out",
    {path:"$.output.results[*]", key:"url"},
    {path:"$.output.results[*]", key:"url"});
};

NormalizeUrl.prototype.run = function (task) {
  var context = this;
  // This is not quite right: we're using the URL of the currently
  // loaded page as the base for normalisation, whereas we really want
  // the URL of the page that the results were parsed from.  But that
  // information is not saved by the parse steps, and it's hard to
  // imagine why you'd ever make a connector that parsed results,
  // navigated away and THEN normalised the URLs.  So that's all
  // right, then.
  var url0 = this.getPageDoc().URL;
  var baseURL = url0.replace(/(.?\/\/.*?)\/.*/, "$1");
  var baseWithPath = url0.replace(/(.*\/).*/, "$1");

  var normalize = function (val) {
    if (typeof(val) === "undefined")
      return undefined;
    if (val.match(/^http(s?):/)) {
      //dump("NormalizeUrl: not touching '" + val + "'\n")
      return val;
    } else if (val.match(/^\//)) {
      //dump("NormalizeUrl: prepending baseURL '" + baseURL + "' to '" + val + "'\n")
      return baseURL + val;
    } else {
      //dump("NormalizeUrl: prepending baseWithPath '" + baseWithPath + "' to '" + val + "'\n")
      return baseWithPath + val;
    }
  }

  if (context.conf.do_url)
    jsonPathHelper.mapElements(
      {path:"$.output.results[*]", key:"url"},
      {path:"$.output.results[*]", key:"url"},
      normalize, task.data);
  if (context.conf.do_thumburl)
    jsonPathHelper.mapElements(
      {path:"$.output.results[*]", key:"thumburl"},
      {path:"$.output.results[*]", key:"thumburl"},
      normalize, task.data);
  if (context.conf.do_fulltexturl)
    jsonPathHelper.mapElements(
      {path:"$.output.results[*]", key:"fulltexturl"},
      {path:"$.output.results[*]", key:"fulltexturl"},
      normalize, task.data);
  if (context.conf.do_permalink)
    jsonPathHelper.mapElements(
      {path:"$.output.results[*]", key:"permalink"},
      {path:"$.output.results[*]", key:"permalink"},
      normalize, task.data);
  if (context.conf.do_custom)
    jsonPathHelper.mapElements(
      context.conf.in, context.conf.out,
      normalize, task.data);
};

NormalizeUrl.prototype.getClassName = function () {
  return "NormalizeUrl";
};

NormalizeUrl.prototype.getDisplayName = function () {
  return "Normalize URL";
};

NormalizeUrl.prototype.getDescription = function () {
  return "Normalizes URLs in the results by prepending the name of the site to relative URLs.";
};

NormalizeUrl.prototype.getVersion = function () {
  return "1.1";  // 1.1 adds checkboxes for hard-coded url fields
};

NormalizeUrl.prototype.renderArgs = function () {
  var s="";
  if (this.conf.do_url)
    s += "url, ";
  if (this.conf.do_thumburl)
    s += "thumburl, ";
  if (this.conf.do_fulltexturl)
    s += "fulltexturl, ";
  if (this.conf.do_permalink)
    s += "permalink, ";
  if ( this.conf.do_custom &&
       this.conf.in && this.conf.in.key &&
       this.conf.out && this.conf.out.key ) {
    s += this.conf.in.key
    if ( this.conf.in.key != this.conf.out.key )
      s += "->" + this.conf.out.key    
  }
  s = s.replace( /,\s*$/, ""); // remove last comma
  return s;
};

NormalizeUrl.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;

  if (confVer < 0.2) {
    jsonPathHelper.upgradePostProc(this.conf);
  }

  if (confVer < 1.1 ) {
    if ( typeof(conf.in) == "undefined" ||
         typeof(conf.in.path) == "undefined" || 
         ( conf.in.path == "$.output.results[*]" &&
           conf.in.key == "url" ) ) {  // the usual case
      conf.do_url = true;
      conf.do_thumburl = false;
      conf.do_permalink = false;
      conf.do_fulltexturl = false;
      conf.do_custom = false;
      logger.debug("Upgraded normalize_url from " + confVer + ", the usual case");
    } else { // custom field configured
      conf.do_url = false;
      conf.do_thumburl = false;
      conf.do_permalink = false;
      conf.do_fulltexturl = false;
      conf.do_custom = true;
      logger.debug("Upgraded normalize_url from " + confVer + ", special conf");
    }
  }

  return true;
};
