var EXPORTED_SYMBOLS = ["ParseSelector"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import("resource://indexdata/util/logging.js");
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');
Components.utils.import('resource://indexdata/runtime/Task.js');
var logger = logging.getLogger();
var ParseSelector = function () {
  this.conf = {};
  this.conf.recSel = "";
  this.conf.conJP = {};
  this.conf.selectors = [];
};
ParseSelector.prototype = new Step();
ParseSelector.prototype.constructor = ParseSelector;
ParseSelector.prototype.init = function() {};
ParseSelector.prototype.draw = function(surface) {
  Components.utils.import('resource://indexdata/util/xulHelper.js');
  Components.utils.import('resource://indexdata/ui/taskPane.js');
  Components.utils.import('resource://indexdata/ui/app.js');
  var context = this;
  var conf = this.conf;
  // Container
  xulHelper.jsonPathField(surface, this, conf, "conJP", "Container path",
                          null, { rwmode:"w", containermode:"anynode" } );
  let box = xmlHelper.appendNode(surface, "hbox", null, {align: "center"});
  xulHelper.inputField(box, this, "recSel", "Container selector");
  var addButton = xmlHelper.appendNode(box, "button", null, {"label": "Add selector"}, null);
  xmlHelper.appendNode(surface, "separator", null, {'class': 'groove'});
  // Selectors
  var selBox = xmlHelper.appendNode(surface, "vbox");
  var rmSel = function (e) {
    var hbox = e.target.parentNode;
    hbox.parentNode.removeChild(hbox);
  };
  var saveSels = function () {
    context.conf.selectors = [];
    for (var i = 0; i < selBox.children.length; i++) {
      let cur = selBox.children[i];
      let s = {
        selector: cur.children[0].value,
        attribute: cur.children[2].value,
        variable: cur.children[4].value,
      };
      if (s.selector && s.variable) context.conf.selectors.push(s);
    }
  };
  var addSel = function (s) {
    if (!s) s =  {
      selector: "",
      variable: "",
      attribute: "",
    };
    let fieldBox = xmlHelper.appendNode(selBox, "hbox", null, {align: "center"});
    xmlHelper.appendNode(fieldBox, "textbox", null,
      {flex:"2", value: s.selector} , null);
    xmlHelper.appendNode(fieldBox, "image", null,
      {src: "chrome://cfbuilder/content/icons/format-text-italic.png"}, null);
    xmlHelper.appendNode(fieldBox, "textbox", null,
      {flex:"1", value: s.attribute}, null);
    xmlHelper.appendNode(fieldBox, "image", null,
      {src: "chrome://cfbuilder/content/icons/go-next.png"}, null);
    xmlHelper.appendNode(fieldBox, "textbox", null,
      {flex:"1", value: s.variable}, null);
    let rm = xmlHelper.appendNode(fieldBox, "image", null, {src: "chrome://cfbuilder/content/icons/window-close.png"}, null);
    rm.addEventListener("click", function(e) { rmSel(e); saveSels(); }, false);
    // mouseover highlight
    fieldBox.addEventListener("mouseover", function(e) {
      fieldBox.oldstyle = fieldBox.style;
      fieldBox.setAttribute("style",
                "background-color:#777777; moz-appearance: none");
    }, false);
    fieldBox.addEventListener("mouseout", function(e) {
      if ( fieldBox.oldstyle )
        fieldBox.setAttribute("style",fieldBox.oldstyle);
    }, false);
  };
  var loadSels = function () {
    var sels = context.conf.selectors;
    var loaded = false;
    for (var i = 0; i < sels.length; i++) {
      addSel(sels[i]);
      loaded = true;
    }
    return loaded;
  };
  // Start with a blank selector if there isn't one
  if (!loadSels()) addSel();
  addButton.addEventListener("command", function(e) { addSel(); }, false);
  selBox.addEventListener("input", function(e) { saveSels(); }, false);
};
ParseSelector.prototype.run = function (task) {
  logger.debug("Parsing with these selectors: " + JSON.stringify(this.conf.selectors));
  var recordElements = this.getPageDoc().querySelectorAll(this.conf.recSel);
  var results = this.process(recordElements, this.conf.selectors);
  jsonPathHelper.set(this.conf.conJP, results, this.task.data);
};
ParseSelector.prototype.process = function(recordElements, sels) {
  var results = [];
  for (var i = 0; i < recordElements.length; i++) {
    var result = {};
    for (var j = 0; j < sels.length; j++) {
      var sel = sels[j];
      var fieldElements = recordElements[i].querySelectorAll(sel.selector);
      if (sel.children) {
        result[sel.variable] = this.process(fieldElements, sel.children);
      } else {
        var field = [];
        for (var k = 0; k < fieldElements.length; k++) {
          el = fieldElements[k];
          var a = sel.attribute;
          if (a === "text" || a === "") field.push(el.textContent);
          else if (a === "html") field.push(el.innerHTML);
          else field.push(el.getAttribute(sel.attribute));
        } 
        if (field.length > 0) result[sel.variable] = field;
      } 
    } 
    results.push(result);
  }
  return results;
};
ParseSelector.prototype.processSelectors = function(el, s) {
};
ParseSelector.prototype.processSelector = function(el, s) {
};
ParseSelector.prototype.getClassName = function () { return "ParseSelector"; };
ParseSelector.prototype.getDisplayName = function () {
  return "Parse by Selector";
};
ParseSelector.prototype.getDescription = function () {
  return "Parses results via CSS selectors.";
};
ParseSelector.prototype.getVersion = function () { return "1.0"; };
ParseSelector.prototype.renderArgs = function () {
  if (this.conf.conJP && this.conf.conJP.key) {
    return this.conf.recSel + " -> " + this.conf.conJP.key;
  }
};
ParseSelector.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer) return false;
};
