var EXPORTED_SYMBOLS = ["Renderxml"];

// A step that takes an XML (in string form) and renders it on the page 
// We used to have something like this in the old httpclient, but this got
// factored out of it as a step of its own. It is intended to be used 
// together with the http step, against a web service that returns XML,
// but can be used for other kind of trickery too, probably with the 
// encode/decode steps, or something like that.

// TODO Add options to limit the redering to max nodes, max depth, or max
// children per node. CP-3719

// TODO Consider renderin JSON strings and javascript structures from $.variables

Components.utils.import('resource://indexdata/runtime/Task.js');
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/textHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/htmlHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');
Components.utils.import('resource://indexdata/thirdparty/jsonPath.js');
Components.utils.import("resource://indexdata/runtime/core.js");

var logger = logging.getLogger();

var Renderxml = function () {
  this.className = "Renderxml";
  this.conf = {};
  this.conf.in = { path:'$.temp', key: 'response' };
  this.conf.ctype = "text/xml";
};

const contentTypes = {
  //"text/xml": "text/xml", 
  // TODO text/html works in the builder, but the engine fails with
  //  (NS_ERROR_NOT_IMPLEMENTED) [nsIDOMParser.parseFromString]
  // when running cf-xulrunner-10. -24 works just fine. Re-enable text/html
  // when we are sure of running wiht -24. Remember to add a test case in the
  // test connector! ### 
  "text/xml (proper XML)": "text/xml",
  "text/html (accepts more broken XML)":"text/html"
};

Renderxml.prototype = new Step();
Renderxml.prototype.constructor = Renderxml;
Renderxml.prototype.init = function() {};

//////////////////
// Draw
Renderxml.prototype.draw = function(surface,win) {
  var vb = xmlHelper.appendNode(surface, "vbox", null,
                                {"flex":1/*, "align":"stretch"*/ } );
  var obox = xmlHelper.appendNode(vb, "hbox", null, {"align":"top"} );
  var outField = xulHelper.jsonPathField(obox, this, this.conf, "in",
                                         "Render XML from"); 
  
  var tbox = xmlHelper.appendNode(vb, "hbox", null, {"align":"top"});
  xulHelper.captionField(tbox, "Content-Type");  
  var ctypeField = xulHelper.arraySelectField(tbox, this, "ctype", contentTypes );
    
};

//////////////////
// Run

Renderxml.prototype.run = function (task) {
  var xmlstring = jsonPathHelper.getFirst(this.conf.in, task.data);
  if ( !xmlstring)
    throw new StepError("No XML to render");
  logger.debug("About to parse " + this.conf.ctype + ": " + xmlstring.substring(0,60) );
  var dom = xmlHelper.docFromString( xmlstring, this.conf.ctype );
  var xmldoc = dom.ownerDocument; 
  logger.debug("Overriding with " + typeof(xmldoc) );
  this.task.connector.setPageOverride(xmldoc);  // no url given here

  if (!core.inBuilder) {
    return;  // Inside the engine, we don't need to mess with the screen!
  }

  // Inside the builder, we need to do a lot more to get a
  // a decent page to display. Just getting it to blank is a mess,
  // as pageload is supposed to be asynchronous.
  var context = this;
  var event = "DOMContentLoaded";

  var eventhandler = function (e) { // This gets called once we have a blank page
    task.debug("event: " + event );
    try {
      if (e) {
        core.getBrowser().removeEventListener(event, eventhandler, false);
      }
      var pagedoc = task.connector.getRealPageDoc();
      logger.debug("Trying to render XML");
      logger.debug(xmlstring);
      pagedoc.body.innerHTML = "XML doc <br/>" +  // clears the old stuff from page
                               "Rendered as " + context.conf.ctype + " <p/>";
      htmlHelper.renderXml( xmldoc, pagedoc, pagedoc.body)
    } catch(err) {
      task.debug("Renderxml caught an exception: " + err );
      throw new StepError( err );
    }
    if (e) {
      task.debug("Resuming task");
      task.resume();
    }
  }; // eventhandler


  //task.debug("About to blank the page");
  var curloc = this.getPageDoc().location;
  if (curloc == "about:blank" || curloc == null ) {
    task.debug("already on a blank page, reusing it. (curloc=" + curloc );
    eventhandler(false);
  } else {
    task.debug("About to blank the page (cur=" + curloc + ")");
    core.getBrowser().addEventListener(event, eventhandler, false);
    core.getBrowser().loadURI("about:blank");
  }

};


//////////////////
// Housekeeping

Renderxml.prototype.getClassName = function () {
  return "Renderxml";
};

Renderxml.prototype.getDisplayName = function () {
  return "Render XML";
};

Renderxml.prototype.getDescription = function () {
  return "Turn a XML string into the current page";
};

Renderxml.prototype.getVersion = function () {
  return "1.0";
};

// Not much point in a renderArgs, way too complex to show in the builder
// Show the type (GET/POST), just to have something
Renderxml.prototype.renderArgs = function () {
  return "";
};

Renderxml.prototype.capabilityFlagDefault = function ( flag ) {
  //if (flag == "webservice-connector")
  //  return true;
  return null;
};

Renderxml.prototype.getUsedArgs = function () {
  return [];
}


Renderxml.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  // TODO - Add something here, when/if making the next version
  return true;
};

