var EXPORTED_SYMBOLS = ["SetAttribute"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');

var SetAttribute = function () {
  // this is only used as the init values for the display if no configuration
  // is provided, e.g when new step is added to the task
  this.conf = {
      dest: '',
      param: undefined,
      constant: undefined,
      attribute: '',
      usejp: false,
      // One of 'empty', 'fail', 'remove', or 'noop'
      onempty: 'empty'
  };
};
SetAttribute.prototype = new Step();
SetAttribute.prototype.constructor = SetAttribute;

SetAttribute.prototype.init = function() {};

SetAttribute.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  var context=this;
  var radiogroup = xmlHelper.appendNode(surface, "radiogroup");
  
  var hbox = xmlHelper.appendNode(radiogroup, "hbox", null, {align:"center"}, null);
  xmlHelper.appendNode(hbox, "label", "Element: ");
  var nodePicker = xulHelper.singleNodeField(hbox, this, "dest");
  
  xulHelper.inputField(surface, this, 'attribute', 'Attribute to set', '110');

  hbox = xmlHelper.appendNode(radiogroup, "hbox", null, {align:"center"}, null);
  var argRadio = xmlHelper.appendNode(hbox, "radio", null, {"id":"argRadio", "label":"Populate with stored data:"});

  var jpField = xulHelper.jsonPathField(hbox, this, this.conf, "param");

  hbox = xmlHelper.appendNode(radiogroup, "hbox", null, {align:"center"}, null);
  var constRadio = xmlHelper.appendNode(hbox, "radio", null, {"id":"constRadio", "label":"Populate with constant:"});
  var constInput = xmlHelper.appendNode(hbox, "textbox", null, {"value":this.conf["constant"]||"", "flex":"1"});

  xmlHelper.appendNode(surface, "separator", null, {'class': 'groove'});
  xmlHelper.appendNode(surface, "caption", null, {'label':'When source empty:'});
  var emptyRadioGroup = xmlHelper.appendNode(surface, "radiogroup");
  var emptyRadios = {};
  emptyRadios.empty = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'empty', 'label':'Set empty value'});
  emptyRadios.noop = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'noop', 'label':'Do nothing'});
  emptyRadios.remove = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'remove', 'label':'Remove attribute'});
  emptyRadios.fail = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'fail', 'label':'Fail'});
  emptyRadioGroup.selectedItem = emptyRadios[this.conf.onempty];


  // reflect saved values
  if (context.conf.usejp) radiogroup.selectedItem = argRadio;
  else radiogroup.selectedItem = constRadio;

  var selectJP = function (e) {
    context.task.debug("Selected JSONpath.");
    context.conf.usejp = true;
    context.draw(surface);
  };

  var selectConstant = function (e) {
    context.task.debug("Selected constant.");
    context.conf.usejp = false;
    context.conf["constant"] = constInput.value;
  };

  emptyRadioGroup.addEventListener('select', function(e) {
    context.conf.onempty = e.target.value;
  }, false);

  radiogroup.addEventListener("select", function(e) {
    if (e.target.localName === "radiogroup") {
      if (!context.conf.usejp && radiogroup.selectedItem === argRadio) selectJP(e);
      else if (radiogroup.selectedItem === constRadio) selectConstant(e);
    }
  }, false);

  jpField.addEventListener("command", function (e) { radiogroup.selectedItem = argRadio; }, false);
  jpField.addEventListener("input", function (e) { radiogroup.selectedItem = argRadio; }, false);
  constInput.addEventListener("input", function (e) { radiogroup.selectedItem = constRadio; }, false);
};


SetAttribute.prototype.run = function (task) {
  if (!this.conf['dest']) throw new StepError("destination not specified in the configuration");
  let nodeSpec = jsonPathHelper.inlineReplaceNodeSpec(this.conf.dest, task.data);
  let dest = xmlHelper.getElementByNodeSpec(this.getPageDoc(), nodeSpec);
  if(!dest) throw new StepError("destination element not found");
  if (this.conf.usejp) {
    var val = jsonPathHelper.getFirst(this.conf.param, task.data);
    var container = this.conf['param'].key;
  } else {
    var val = this.conf.constant;
    var container = 'constant';
  }
  // 0 is the only falsy value that doesn't count as empty
  if (val || typeof val === 'number') {
    dest.setAttribute(this.conf.attribute, val); 
    task.info('value of ' + this.conf.attribute + ' set to "' + val + '" from ' + container, this);
  } else if (this.conf.onempty === 'empty') {
    dest.setAttribute(this.conf.attribute, ''); 
    task.info('value of ' + this.conf.attribute + ' set to an empty string, ' + container + ' is ' + val, this);
  } else if (this.conf.onempty === 'fail') {
    throw new StepError("empty value");
  } else if (this.conf.onempty === 'remove') {
    dest.removeAttribute(this.conf.attribute);
  } else if (this.conf.onempty === 'noop') {
    task.info('value to set is empty, continuing');
  } 
  var changeEvent = this.getPageDoc().createEvent('HTMLEvents');
  changeEvent.initEvent('change', true, true);
  dest.dispatchEvent(changeEvent);
};

SetAttribute.prototype.getUsedArgs = function () {
 if (this.conf.param && this.conf.param.path === "$.input")
   return [this.conf.param.key];
 else
   return [];
}

SetAttribute.prototype.getClassName = function () {
  return "SetAttribute";
};

SetAttribute.prototype.getDisplayName = function () {
  return "Set attribute";
};

SetAttribute.prototype.getDescription = function () {
  return "Sets the attribute property of an element.";
};

SetAttribute.prototype.getVersion = function () {
  return "1.0";
};

SetAttribute.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  return true;
};

SetAttribute.prototype.renderArgs = function () {
  if (!this.conf.dest) return "";
  else if (this.conf.usejp) return this.conf.param.path + "." + this.conf.param.key;
  else return this.conf.constant;
};
