var EXPORTED_SYMBOLS = ["SetValue"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();

var SetValue = function () {
  // this is only used as the init values for the display if no configuration
  // is provided, e.g when new step is added to the task
  this.conf = {
      dest: '',
      param: { path:"", key:"" },
      usejp: false,
      // One of 'empty', 'fail', or 'noop'
      onempty: 'empty'
  };
};
SetValue.prototype = new Step();
SetValue.prototype.constructor = SetValue;

SetValue.prototype.init = function() {};

SetValue.prototype.draw = function(surface) {
  xmlHelper.emptyChildren(surface);
  var context=this;
  var radiogroup = xmlHelper.appendNode(surface, "radiogroup");

  // if you're setting a select element you can pick an option to populate constant
  // should you decide not to we stop listening once you move into the step pane
  var selectNode = null;
  var onNodeSelect = function(node) {
    if (node.localName.toLowerCase() == "select") {
      selectNode = node;
      node.addEventListener("change", grabOption, false);
    }
  };

  var hbox = xmlHelper.appendNode(surface, "hbox", null, {align:"center"}, null);
  xmlHelper.appendNode(hbox, "label", "Form field to populate: ");
  var nodePicker = xulHelper.singleNodeField(hbox, this, "dest", onNodeSelect);

  hbox = xmlHelper.appendNode(surface, "hbox", null, {align:"center"}, null);

  var jpField = xulHelper.jsonPathField(hbox, this, this.conf, "param", "Value", null,
        { rwmode:"r", singlevalue: true,
          constantallowed: true,  expandvariables: true,
        } );


  xmlHelper.appendNode(surface, "separator", null, {'class': 'groove'});
  xmlHelper.appendNode(surface, "caption", null, {'label':'When source empty:'});
  var emptyRadioGroup = xmlHelper.appendNode(surface, "radiogroup");
  var emptyRadios = {};
  emptyRadios.empty = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'empty', 'label':'Set empty value'});
  emptyRadios.noop = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'noop', 'label':'Do nothing'});
  emptyRadios.fail = xmlHelper.appendNode(emptyRadioGroup, 'radio', null, {'value':'fail', 'label':'Fail'});
  emptyRadioGroup.selectedItem = emptyRadios[this.conf.onempty];



  emptyRadioGroup.addEventListener('select', function(e) {
    context.conf.onempty = e.target.value;
  }, false);


};


SetValue.prototype.run = function (task) {
  if (!this.conf['dest']) throw new StepError("destination not specified in the configuration");
  let nodeSpec = jsonPathHelper.inlineReplaceNodeSpec(this.conf.dest, task.data);
  let dest = xmlHelper.getElementByNodeSpec(this.getPageDoc(), nodeSpec);
  if(!dest) throw new StepError("destination element not found");
  var val = jsonPathHelper.getFirst(this.conf.param, task.data);
  // 0 is the only falsy value that doesn't count as empty
  if (val || typeof val === 'number') {
    dest.value = val; 
    task.info('value set to "' + val + '" from ' +
        jsonPathHelper.displayString(this.conf.param,true), this );
  } else if (this.conf.onempty === 'empty') {
    dest.value = "";
    task.info('value set to an empty string, from "'  + val + '"', this);
  } else if (this.conf.onempty === 'fail') {
    throw new StepError("empty value");
  } else if (this.conf.onempty === 'noop') {
    task.info('value to set is empty, continuing');
  } 
  var changeEvent = this.getPageDoc().createEvent('HTMLEvents');
  changeEvent.initEvent('change', true, true);
  dest.dispatchEvent(changeEvent);
};

/* The (new) default in Step.js seems to be good enough 
SetValue.prototype.getUsedArgs = function () {
  return jsonPathHelper.usedArgs(this, "param");
};
*/

SetValue.prototype.getClassName = function () {
  return "SetValue";
};

SetValue.prototype.getDisplayName = function () {
  return "Set form value";
};

SetValue.prototype.getDescription = function () {
  return "Sets the value property of an element and fires a change event on it.";
};

SetValue.prototype.getVersion = function () {
     // 4.0 introduced onempty 
  return "4.1";  // 4.1 moved the constant into the jp
};

SetValue.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.5) {
    if (typeof conf['dest'] == "string") {
      var oldTarget = conf['dest'];
      conf['dest'] = {};
      conf['dest']['xpath'] = oldTarget;
    }
  }
  if (confVer < 0.6) {
    if (conf.param)
      conf.param = {path: "$.input", key: conf.param};
  }
  if (confVer < 2.0) {
    if (conf.constant)
      conf.usejp = false;
    else
      conf.usejp = true;
  }
  if (confVer < 4.0) {
    if (!conf.usejp)
      conf.onempty = 'fail';
    else
      conf.onempty = 'noop';
  }
  if (confVer < 4.1) {
    logger.debug("SetValue upgrade from " + confVer + " conf: " + JSON.stringify(conf) );
    if ( ! conf.param )
      conf.param = { path:"", key:"" };
    conf.param.useconstant =  ! conf.usejp;
    conf.param.constantvalue = conf.constant;
    if ( typeof(conf.param.constantvalue) == "string" &&
         conf.param.constantvalue.match( /\{\$./ ) ) {
      conf.param.expandvariables = true;
    }
    conf.constant = undefined;
    conf.usejp = undefined;
    logger.debug("SetValue upgrade done " + JSON.stringify(conf) );

  }
  return true;
};

SetValue.prototype.renderArgs = function () {
  if (!this.conf.dest)
    return "";
  else if (this.conf.usejp)
    return this.conf.param.path + "." + this.conf.param.key;
  else
    return this.conf.constant;
}


SetValue.prototype.capabilityFlagDefault = function (flag) {
    if (this.task.name === "init" && flag.substring(0, 5) == "init-") {
	var param = this.conf.param;
	//this.task.debug("set_value considering capability '" + flag + "', param = '" + param.key + "' in task '" + this.task.name + "'");
        var wanted = flag.substring(5);
        if (typeof(param) != "undefined" &&
	    param.path === "$.input" &&
	    param.key === wanted) {
            return true;
	}
        // Note, do not return false if the argument is not not there:
        // other steps may still make use of it.
    }

    // Pass up to the superclass's default implementation
    return Step.prototype.capabilityFlagDefault.call(this, flag);
}
