var EXPORTED_SYMBOLS = ["Skip"];
Components.utils.import('resource://indexdata/runtime/Step.js');
Components.utils.import('resource://indexdata/runtime/StepError.js');
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import('resource://indexdata/util/xulHelper.js');
Components.utils.import('resource://indexdata/util/jsonPathHelper.js');
Components.utils.import('resource://indexdata/runtime/Conditional.js');
Components.utils.import('resource://indexdata/util/logging.js');

var logger = logging.getLogger();

var Skip = function () {
  this.conf = {};
  //defaults
  this.conf['stepsToSkip'] = 1;
  this.conf['skipAll'] = false;
  this.conf.conditions = [];
};
Skip.prototype = new Step();
Skip.prototype.constructor = Skip;

Skip.prototype.init = function(task) {
  this.conditional = new Conditional(this.conf.conditions, this.task.data);
};

function getToSkipType(me, stepsToSkip) {
  let i = me.block.findStepIndex(me);
  dump('-----------i '+i+"toSKip:"+stepsToSkip+"\n");
  let type = '';
  if ((i+stepsToSkip) < me.block.steps.length) {
    type = me.block.steps[i+stepsToSkip].getClassName();
  } else {
    type = "out-of-range";
  }
  return type;
}

Skip.prototype.draw = function(surface) {
  logger.debug("skip.draw: conf: " + JSON.stringify(this.conf) );
  logger.debug("skip.draw: cond: " + JSON.stringify(this.conditional) );
  xmlHelper.appendNode(surface, "caption", "Only run next step(s) if:");
  var condBox = xmlHelper.appendNode(surface, "vbox");
  this.conditional.draw(condBox, this);

  let hbox = xmlHelper.appendNode(surface, "hbox", null, { align: "center" });
  xmlHelper.appendNode(hbox, "caption", "# of steps to skip ");
  let stsInput = xmlHelper.appendNode(hbox, "textbox", null,
    this.conf.stepsToSkip ? {"value": this.conf.stepsToSkip} : {});
  if (this.conf.skipAll) stsInput.disabled = true;

  xmlHelper.appendNode(surface, "spacer", null, { flex: 1 });
  var toSkipLbl = xmlHelper.appendNode(surface, "label");
  var toSkipLblPrefix = "Target step type: ";
  let toSkip = this.conf.stepsToSkip ? this.conf.stepsToSkip : 0;
  let realType = getToSkipType(this, toSkip);
  if (!this.conf.skipAll) {
    if (this.conf['destType']) {
      toSkipLbl.value = toSkipLblPrefix+this.conf['destType'];
      if (realType != this.conf['destType']) {
        toSkipLbl.value += " (actual destination class '"+realType+"' differs!)";
      }
    } else {
      this.conf['destType'] = realType;
      toSkipLbl.value = toSkipLblPrefix+this.conf['destType']
        +" (validated now)";
      //should we send save notification?
    }
  } else {
      toSkipLbl.value = "Skipping all steps";
  }
  var context = this;
  stsInput.addEventListener("input", function (e) {
    let toSkip = parseInt(stsInput.value);
    context.conf['stepsToSkip'] = toSkip;
    if (!context.conf.skipAll) {
      let type = getToSkipType(context, toSkip);
      toSkipLbl.value = toSkipLblPrefix+type;
      context.conf['destType'] = type;
    } else {
      toSkipLbl.value = "Skipping all steps";
    }
  }, false);
  let scb = xulHelper.checkbox(hbox, this, "skipAll",
      " Skip till end?");
  scb.addEventListener("click", function (e) {
    //context.conf points to previous value here
    if (!context.conf.skipAll) {
      stsInput.disabled = true;
      toSkipLbl.value = "Skipping all steps";
    } else {
      stsInput.disabled = false;
      let type = getToSkipType(context, toSkip);
      toSkipLbl.value = toSkipLblPrefix+type;
    }
  }, false);
};

Skip.prototype.run = function (task, block) {
  //be bacwards compat: undefined == false
  if (this.conf['skipAll']) {
    var skipAll = true;
  } else if (typeof this.conf.stepsToSkip != "number") {
    throw new StepError("steps-to-skip not specified as a number in "
        + "the configuration ("+this.conf.stepsToSkip+")");
  }
  // warn if dest step type differs
  var type = getToSkipType(this,this.conf.stepsToSkip);
  if (!skipAll && this.conf.destType && this.conf.destType != type)
    task.warn("Target step class is "+type+" while configuration value is "
        + this.conf.destType+", please review the step config!", this);
  if (this.conditional.eval()) {
    task.info("Predicate " + String(this.conditional) + " is true, running next step...", this);
  } else {
    let msg = skipAll ? "to end" : this.conf.stepsToSkip + " step(s)";
    task.info("Predicate " + String(this.conditional) + "is false, skipping "+msg+"...", this);
    if (skipAll)
      block.seekEnd();
    else
      block.seekRelative(this.conf['stepsToSkip']);
  }
};

Skip.prototype.getClassName = function () {
  return "Skip";
};

Skip.prototype.getDisplayName = function () {
  return "Next if";
};

Skip.prototype.getDescription = function () {
  return "Controls execution of a consecutive step by checking a predicate";
};

Skip.prototype.getVersion = function () {
  //return "2.0";
  return "3.0";  // uses the improved conditional, with constants inside jp
};

Skip.prototype.upgrade = function (confVer, curVer, conf) {
  // can't upgrade if the connector is newer than the step
  if (confVer > curVer)
    return false;
  if (confVer < 0.2) {
    conf['stepsToSkip'] = 1;
  }
  if (confVer < 0.3) {
    conf.compareTo = {path: "$.input", key: conf.argName};
    delete conf.argName;
  }
  if (confVer < 2.0) {
    conf.conditions = [{
      operands: [
        {usejp: true, jp:conf.compareTo}, 
        {usejp: false, value: conf.expArgVal}
      ],
      operator: this.conf.useRegex ? 'match' : 'equals',
      negate: this.conf.rel === 'neq'
    }];
    delete conf.compareTo; 
    delete conf.expArgVal;
    delete conf.rel;
    delete conf.useRegex;
  }
  if (confVer < 3.0) {
    var c = new Conditional(conf.conditions, null);
    c.upgradeConstants();
    conf.conditions = c.conditions;
    logger.debug("skip: upgraded conditions to " + JSON.stringify( conf.conditions) );
  }
  return true;
};

Skip.prototype.getUsedArgs = function () {
  let args = this.conditional.getUsedArgs();
  return args;
};

Skip.prototype.renderArgs = function () {
  if (this.conditional) return String(this.conditional);
};

Skip.prototype.isDeprecated = function () {
  return true;
};

Skip.prototype.getIndentRange = function () {
  let indentTo = this.conf.skipAll ? -1 : this.conf.stepsToSkip+1;
  return [1, indentTo];
};
