var EXPORTED_SYMBOLS = ["XpathRefine"];
Components.utils.import('resource://indexdata/util/xmlHelper.js');
Components.utils.import("resource://indexdata/util/mozHelper.js");

// element in the same document, xpath, callback function to pass new xpath string
var XpathRefine = function (elem, xpath, cb) {
  var context = this;
  this.xpath = xpath;
  this.pagedoc = elem.ownerDocument || elem.documentElement.ownerDocument;
  this.doc = null;
  this.win = null;
  this.original = xpath;
  this.components = xpath.split('/');
  // shallow copy
  this.newComponents = this.components.slice(0);
  this.cb = cb;

  this.chromewin = mozHelper.openOrFocusWindow(
    function (e) {
      context.doc = e.target;
      context.win = context.doc.getElementsByTagName("window").item(0);
      context.draw();
    },
    "chrome://cfbuilder/content/xpath_refine.xul",
    "cfXpathRefineWindow",
    "resizable=yes,status=yes,dependent=yes,chrome=yes,centerscreen"
  );
};

XpathRefine.prototype.draw = function() {
  var context = this;
  xmlHelper.emptyChildren(this.win);
  var linkBox = xmlHelper.appendNode(this.win, "label", null, {"id":"cfXpathLinks", "style":"word-wrap:break-word;"});
  this.drawLinks();

  var attrGroup = xmlHelper.appendNode(this.win, "groupbox", null, {"id":"cfXpathAttr", "flex":"1"}, null);
  xmlHelper.appendNode(attrGroup, "caption", null, {"id":"cfXpathAttrCaption", "label":"Click an XPath component..."}, null);

  xmlHelper.appendNode(this.win, "description", null, {"id":"warningText", "style":"text-align:right;"}, null);

  var buttonBox = xmlHelper.appendNode(this.win, "hbox");
  xmlHelper.appendNode(buttonBox, "spacer", null, {"flex":1});
//   var revertButton = xmlHelper.appendNode(buttonBox, "button", null, {"label":"Revert component"}, null);
  var revertAllButton = xmlHelper.appendNode(buttonBox, "button", null, {"label":"Revert all"}, null);
  xmlHelper.appendNode(buttonBox, "spacer");
  var saveButton = xmlHelper.appendNode(buttonBox, "button", null, {"id":"cfXpathSave", "label":"Save"}, null);
  var cancelButton = xmlHelper.appendNode(buttonBox, "button", null, {"label":"Cancel"}, null);

  saveButton.addEventListener("command", function (e) {
    context.cb(context.getNewXpath());
    context.chromewin.close();
  }, false);

  cancelButton.addEventListener("command", function (e) {
    context.chromewin.close();
  }, false);

  revertAllButton.addEventListener("command", function (e) {
    context.newComponents = context.components.slice(0);
    context.draw();
  }, false);

/*  revertButton.addEventListener("command", function (e) {
    this.currentlyEditing= this.components.slice(0);
    this.draw();
  }, false);*/
};

XpathRefine.prototype.drawLinks = function () {
  var context = this;
  var linkBox = this.doc.getElementById("cfXpathLinks");
  xmlHelper.emptyChildren(linkBox);
  for (var i = 0; i < this.newComponents.length; i++) {
    var label = xmlHelper.appendNode(linkBox, "label", null, {"value":this.newComponents[i], "compidx":i, "class":"text-link", "style":"word-wrap:break-word;"});
    label.addEventListener("click", function(e) {
      context.drawAttr(parseInt(e.target.getAttribute("compidx")));
    }, false);
    if (i < this.newComponents.length - 1)
      xmlHelper.appendNode(linkBox, "label", null, {"value":" / "});
  }
};

XpathRefine.prototype.drawAttr = function(componentIndex) {
  var context = this;
  var node = xmlHelper.getElementByXpath(this.pagedoc, this.components.slice(0, componentIndex+1).join("/")).wrappedJSObject;

  // remove [n] from the end
  var shard = this.newComponents[componentIndex].replace(/\[\d*\]$/, "");

  // parse out textContent contains() calls for editing
  var re = /\[contains\(text\(\), ?\"(.*?)\"\)\]/g;
  var tcMatch = re.exec(shard);
  shard = shard.replace(re, "");

  // parse out attribute contains() calls for editing
  var re = /\[contains\(\@(.*?), ?\"(.*?)\"\)\]/g;
  var pieces;
  var prevAttr = {};
  while (pieces = re.exec(shard)) {
    prevAttr[pieces[1]] = pieces[2];
  }
  shard = shard.replace(re, "");

  this.doc.getElementById("cfXpathAttrCaption").setAttribute("label", this.newComponents[componentIndex]);

  var attrGroup = this.doc.getElementById("cfXpathAttr");
  xmlHelper.emptyChildren(attrGroup, "vbox");
  xmlHelper.emptyChildren(attrGroup, "hbox");

  // controls for textContent
  var tcContainer = xmlHelper.appendNode(attrGroup, "hbox");
  var tcCheckbox = xmlHelper.appendNode(tcContainer, "checkbox");
  xmlHelper.appendNode(tcContainer, "label", null, {"value":"Text Content: "});
  if (tcMatch) {
    var tcTextbox = xmlHelper.appendNode(tcContainer, "textbox", null, {"value":tcMatch[1], "flex":1});
    tcCheckbox.setAttribute("checked", "true");
  } else
    var tcTextbox = xmlHelper.appendNode(tcContainer, "textbox", null, {"value":node.textContent, "flex":1});

  // controls for attributes
  var attrBox = xmlHelper.appendNode(attrGroup, "vbox");
  for (var i = 0; i < node.attributes.length; i++) {
    var attr = node.attributes.item(i);
    var container = xmlHelper.appendNode(attrBox, "hbox");
    var checkbox = xmlHelper.appendNode(container, "checkbox");
    xmlHelper.appendNode(container, "label", null, {"label":attr.name+": ", "value":attr.name});
    if (prevAttr[attr.name]) {
      xmlHelper.appendNode(container, "textbox", null, {"value":prevAttr[attr.name], "flex":1});
      checkbox.setAttribute("checked", "true");
    } else {
      xmlHelper.appendNode(container, "textbox", null, {"value":attr.value, "flex":1});
    }
  }

  var getNewComponent = function () {
    var boxes = attrBox.getElementsByTagName("hbox");
    var newConstraints = {};
    for (var i = 0; i < boxes.length; i++) {
      var checkbox = boxes[i].getElementsByTagName("checkbox")[0];
      var label = boxes[i].getElementsByTagName("label")[0];
      var textbox = boxes[i].getElementsByTagName("textbox")[0];
      if (checkbox.hasAttribute("checked"))
        newConstraints[label.getAttribute("value")] = textbox.value;
    }
    var tail = "";
    if (tcCheckbox.hasAttribute("checked"))
      tail = "[contains(text(), \"" + tcTextbox.value + '")]';
    for (var i in newConstraints) {
      tail = tail + "[contains(@" + i + ', "' + newConstraints[i] + '")]';
    }
    return shard + tail;
  };

  var attrChg = function (e) {
    context.newComponents[componentIndex] = getNewComponent();
    context.drawLinks();
    context.validate();
  };

  attrBox.addEventListener("input", attrChg, false);
  attrBox.addEventListener("change", attrChg, false);
  attrBox.addEventListener("command", attrChg, false);
  tcContainer.addEventListener("input", attrChg, false);
  tcContainer.addEventListener("change", attrChg, false);
  tcContainer.addEventListener("command", attrChg, false);
};

XpathRefine.prototype.getNewXpath = function () {
  return this.newComponents.join("/");
};

XpathRefine.prototype.validate = function () {
  var warningText = this.doc.getElementById("warningText");
  var newXpath = this.getNewXpath();
  // XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE
  var matchCount = this.pagedoc.evaluate(newXpath, this.pagedoc, null, 6, null).snapshotLength;
  if (matchCount==1) {
    warningText.setAttribute("value", "");
  } else if (matchCount>1) {
    warningText.setAttribute("value", "Warning: " + matchCount + " elements match this XPath.");
  } else {
    warningText.setAttribute("value", "Warning: No elements match this XPath.");
  }
};
