var EXPORTED_SYMBOLS = ["app"];
const APP_ID = "cfbuilder@indexdata.com";
var Cc = Components.classes;
var Ci = Components.interfaces;
Components.utils.import("resource://indexdata/runtime/core.js");
let xulAppInfo = Components.classes["@mozilla.org/xre/app-info;1"].getService(Components.interfaces.nsIXULAppInfo);
core.setPlatformVersion(xulAppInfo.platformVersion);
Components.utils.import("resource://indexdata/util/Subject.js");
Components.utils.import("resource://indexdata/runtime/ConnectorTemplate.js");
Components.utils.import("resource://indexdata/runtime/Connector.js");
Components.utils.import('resource://indexdata/util/Highlighter.js');
Components.utils.import('resource://indexdata/util/logging.js');
Components.utils.import("resource://gre/modules/AddonManager.jsm");
var logger = logging.getLogger();
var IS_EXTENSION = true;
var wm = Cc["@mozilla.org/appshell/window-mediator;1"]
  .getService(Ci.nsIWindowMediator);
var idprefs = core.idprefs;

/**
 * This class contains all global vars used throuoghout the application
 * (open connector, selected task) everything that needs to be referred from
 * multile windows should end-up here. This class is also used for app-wide
 * "message-bus" working in a publish/subscribe model (provided by the Subject
 * util class), you can do cross-window communication/event-notification by using
 * its capabilites.
**/
app = new Subject([
    "id",
    "addon",
    "version",
    "mainWindow",
    "template",
    "activeTest",
    "connector",
    "selectedTask",
    "selectedStep",
    "lastOpened",
    "canSave",
    "saveTimer",
    "stickyNewStep",
    "listAllSteps",
    "highlighter",
    "quit",
    "fullqueryEdited",
    "proxied"
  ]);

// we wait for the addon object before loading anything
app.subscribe('addon', function() {
  if (!app.loadState()) {
    app.openDefaultTemplate();
    app.newConnector();
  } 
});
app.set('proxied', false);
app.set("id", APP_ID);
AddonManager.getAddonByID(app.id, function(addon) {
  core.set("cfRootFile", addon.getResourceURI('/').QueryInterface(Ci.nsIFileURL).file);
  try {
    // prefer version from IDMETA if found (dereference cfroot)
    if (core.cfRootFile.target) {
      let file = Components.classes["@mozilla.org/file/local;1"]
          .createInstance(Components.interfaces.nsILocalFile);
      file.initWithPath(core.cfRootFile.target);
      file = file.parent;
      file.append('IDMETA');
      if (file.isFile()) {
        let stream = Cc["@mozilla.org/network/file-input-stream;1"]
          .createInstance(Ci.nsIFileInputStream);
        stream.init(file, 0x01, 0444, 0);
        stream.QueryInterface(Ci.nsILineInputStream);
        let line = {};
        let hasmore = true;
        while (hasmore) {
          hasmore = stream.readLine(line);
          let m = line.value.match(/^VERSION=(.*)$/);
          if (m) {
            core.set("version", m[1]);
          }
        }
        stream.close();
      }
    }
  } catch (e) {
  }
  // otherwise use version from install.rdf
  if (!core.version) core.set("version", addon.version);
  app.set("addon", addon);
});
// Block so we know we have the addon when we load the auto-saved connector
Cc["@mozilla.org/thread-manager;1"]
  .getService(Ci.nsIThreadManager)
  .currentThread.processNextEvent(false);

app.saveTimer = null;
app.listAllSteps = false;
try {
  app.stickyNewStep = idprefs.getBoolPref("stickyNewStep", app.stickyNewStep);
} catch (e) { 
  app.stickyNewStep = false;
}
app.tabReuse = {};

// Observer -- right now just for quit
let observerService = Cc["@mozilla.org/observer-service;1"]
  .getService(Ci.nsIObserverService);
observerService.addObserver(app, "quit-application", false);

app.observe = function (subject, topic, data) {
  if (topic === "quit-application") app.notify("quit");
};

app.openResAndDo = function (path, onres) {
  if (typeof path != "object")
    throw new Error("path must be an array");
  if (typeof onres != "function")
    throw new Error("onres arg must be a function");
  Components.utils.import("resource://gre/modules/AddonManager.jsm");
  AddonManager.getAddonByID(APP_ID, function(addon) {
    var file = addon.getResourceURI(path.join('/'))
    .QueryInterface(Ci.nsIFileURL).file;
    logger.debug("Opening resource at "+file.path)
    onres(file);
  });
};

app.disableApp = function () {
  var man = Cc["@mozilla.org/extensions/manager;1"];
  if (man) {
    man = man.getService(Ci.nsIExtensionManager);
    man.disableItem(app.id);
  } else {
    Components.utils.import("resource://gre/modules/AddonManager.jsm");
    AddonManager.getAddonByID(app.id, function(addon) {
      addon.userDisabled = true;
    });
  }
};

app.getBrowserWidget = function (windowCtx) {
  try {
    IS_EXTENSION = true;
    return windowCtx.top.getBrowser()
      .browsers[windowCtx.top.getBrowser().mTabBox.selectedIndex];
  } catch (e) {
    IS_EXTENSION = false;
    logger.debug(e);
    return windowCtx.document.getElementById("pageBrowser");
  }
};

app.reloadTabIfOpen = function (url, bringToFront) {
  var tabbrowser = this.mainWindow.gBrowser;
  for (var i=0; i<tabbrowser.browsers.length; i++) {
    if (url == tabbrowser.getBrowserAtIndex(i).currentURI.spec) {
      var tab = tabbrowser.tabContainer.childNodes[i];
      if (bringToFront === true)
        tabbrowser.selectedTab = tab;
      tabbrowser.reloadTab(tab);
      return true;
    }
  }
  return false;
};

app.openOrReuseTab = function (url) {
  var tabbrowser = this.mainWindow.gBrowser;
  var exists = false;
  if (this.tabReuse[url] && this.tabReuse[url].linkedBrowser) {
    // we've opened this before so lets switch to that tab if
    // it's still around and pointing at vaguely the same url
    if (this.tabReuse[url].linkedBrowser.currentURI
      && this.tabReuse[url].linkedBrowser.currentURI.spec.split("?")[0]
      == url.split("?")[0]) {
      exists = true;
      tabbrowser.selectedTab = this.tabReuse[url];
    }
  }

  if (!exists) {
    for (var i=0; i<tabbrowser.browsers.length; i++) {
      if (url == tabbrowser.getBrowserAtIndex(i).currentURI.spec) {
        // this url is already open in the window with the builder,
        // we should just switch to it instead of opening a new one.
        tabbrowser.selectedTab = tabbrowser.tabContainer.childNodes[i];
        this.tabReuse[url] = tabbrowser.selectedTab;
        exists = true;
        break;
      }
    }
  }
  if (!exists) {
    tabbrowser.selectedTab = tabbrowser.addTab(url, null, null, null, null);
    this.tabReuse[url] = tabbrowser.selectedTab;
  }
};

app.openDefaultTemplate = function () {
  app.template = new ConnectorTemplate();
  try {
    app.template.loadFromUUID(idprefs.getCharPref('defaulttemplate'));
  } catch (e) {
    logger.debug(e);
    // TODO: it should be possible to operate without a template and that 
    // should be the fallback instead of hardcoding
    app.popupError("Cannot open default template: " + e.message + " Loading fallback.");
    app.template.loadFromUUID('search.cft');
    idprefs.setCharPref('defaulttemplate', 'search.cft');
    app.notify("template");
    if (!app.connector) app.newConnector();
  }
};

app.loadTemplate = function (file) {
  app.template = new ConnectorTemplate();
  logger.debug("Loading template from " + file.path);
  try {
    app.template.loadFromFile(file);
    app.connector = null;
    app.notify("template");
    app.newConnector();
  } catch (e) {
    logger.debug(e);
    app.popupError("Cannot open template: " + e.message + " in " + e.fileName + ":" + e.lineNumber);
    return;
  }
};

app.popupError = function (errorMsg) {
  if (app.mainWindow) app.mainWindow.alert(errorMsg);
};

app.saveFileAs = function (winCtx) {
  var proposedName = "new_connector";
  if (app.connector.metaData.origin) {
    proposedName = app.connector.metaData.origin.replace(/.*[\/\\]/, "")
      .replace(/\..*/,"");
  } else if (app.connector.metaData.title) {
    proposedName = app.connector.metaData.title.toLowerCase()
      .replace(/\s+/g, '_');
  }
  app.openBrowseDialog(winCtx, "Choose file to save connector...",
    "save", function (fp) {
      try {
        app.connector.saveConfToFile(fp.file);
      } catch (e) {
        logger.debug(e);
        app.popupError("Cannot save file: " + e.message);
        return;
      }
      app.set("canSave", false);
      app.set("lastOpened", fp.file);
    }, {"name" : "CF Connector", "ext" : "*.cf"}, null, proposedName, 'cf');
};
app.changedConnector = function () {
  // for the time being we coerce templateless connectors into the
  // current template as per previous behaviour
  if (!app.connector.template) app.connector.template = app.template;
  // use test session values for builder
  // * only on load so they persist between task invocations
  app.connector.useSessionTestValues();
  app.set("canSave", false);
  app.notify("template");
  app.notify("connector");
};
app.saveFile = function (windowCtx) {
  if (app.lastOpened == null) return app.saveFileAs(windowCtx);
  try {
    app.connector.saveConfToFile(app.lastOpened.path);
  } catch (e) {
    logger.debug(e);
    app.popupError("Cannot save file: " + e.message);
    return;
  }
  app.set("canSave", false);
};

app.loadFile = function (windowContext) {
  if (!app.promptUnsaved()) return false;
  app.openBrowseDialog(windowContext, "Choose connector file..",
    "load", function (fp) {
      app.connector = new Connector();
      try {
        app.connector.loadConfFromFile(fp.file.path); 
      } catch (e) {
        logger.debug(e);
        app.popupError("Cannot open file: " + e.message);
        return;
      }
      app.set("lastOpened", fp.file);
      app.changedConnector();
    }, {"name" : "CF Connectors", "ext" : "*.cf"}, null, null, 'cf'
  );
};

app.newConnector = function () {
  if (!app.promptUnsaved()) return false;
  app.connector = new Connector(app.template);
  for (var key in app.template.requirements) {
    logger.debug(" - creating task from requirements for '"+key+"'");
    var task = app.connector.createTask(key);
    task.createDefaultTests();
  }
  app.changedConnector();
  app.set('lastOpened', null);
};

app.promptUnsaved = function () {
  var prompts = Cc["@mozilla.org/embedcomp/prompt-service;1"]
    .getService(Ci.nsIPromptService);
  if (!app.canSave || prompts.confirm(null, "Please confirm", "Discard unsaved changes?"))
    return true;
  else
    return false;
}

app.changeTemplate = function (winCtx) {
  if (!app.promptUnsaved()) return false;
  var initDir = null;
  app.openResAndDo(["templates"],
    function (initDir) {
      app.openBrowseDialog(winCtx, "Choose template file..", "load",
        function (fp) {
          app.loadTemplate(fp.file, winCtx);
          app.set("lastOpened", null);
        },
        {"name" : "CF Templates", "ext" : "*.cft"}, initDir,
        null, 'cft');
    }
  );
};

app.openBrowseDialog = function (winCtx, winName, mode, onSelect, ftype,
                      initDir, defaultFileName, defaultExtension) {
  const nsIFilePicker = Ci.nsIFilePicker;
  var fp = Cc["@mozilla.org/filepicker;1"]
    .createInstance(nsIFilePicker);
  fp.init(winCtx, winName,
      mode === "load" ? nsIFilePicker.modeOpen : nsIFilePicker.modeSave);
  if (ftype)
    fp.appendFilter(ftype["name"], ftype["ext"]);
  if (initDir)
    fp.displayDirectory = initDir;
  if (defaultFileName)
    fp.defaultString = defaultFileName;
  if (defaultExtension)
    fp.defaultExtension = defaultExtension;
  //one would think that this coould be easily done with do/while
  //ut FF doesn't like it
  var showFp = function () {
    var confirmed = true;
    var rv = fp.show();
    if (rv == nsIFilePicker.returnOK || rv == nsIFilePicker.returnReplace) {
      //now check if the defaultExtension was really appended
      if (defaultExtension &&
          fp.file.path.indexOf(defaultExtension, fp.file.path.length -
            defaultExtension.length) == -1) {
        var prompts =
        Cc["@mozilla.org/embedcomp/prompt-service;1"]
          .getService(Ci.nsIPromptService);
        confirmed = prompts.confirm(null, "Please confirm",
          "You are about to save the file without its default extension (."
          +defaultExtension+") and your platform does not append extensions "
          +"automatically. It may be impossible to re-open the file without "
          +"renaming it. Are you sure you want to continue?");
      }
      if (confirmed) {
        onSelect(fp);
        return;
      } else {
        showFp();
        return;
      }
    }
  }
  showFp();
};

app.saveState = function (timer) {
  let xs = Cc["@mozilla.org/xmlextras/xmlserializer;1"].
    createInstance(Ci.nsIDOMSerializer);
  idprefs.setCharPref("state.connector",
    xs.serializeToString(app.connector.saveConf()));
  if (app.lastOpened && app.lastOpened.path)
    idprefs.setComplexValue("state.lastopenedfile",
      Ci.nsILocalFile, app.lastOpened);
  else
    idprefs.setCharPref("state.lastopenedfile", "");
  idprefs.setBoolPref("state.cansave", app.canSave);
  app.saveTimer = null;
  logger.debug("Connector state saved.");
};
app.saveStateIfYouHaventRecently = function () {
  if (app.connector && app.saveTimer === null) {
    app.saveTimer = Cc["@mozilla.org/timer;1"]
          .createInstance(Ci.nsITimer);
    var timerCb = { notify: app.saveState};
    app.saveTimer.initWithCallback(timerCb, 2000,
      Ci.nsITimer.TYPE_ONE_SHOT);
  }
};
app.subscribe("connector", app.saveStateIfYouHaventRecently);
app.subscribe("canSave", app.saveStateIfYouHaventRecently);
app.subscribe("template", app.saveStateIfYouHaventRecently);
app.subscribe("quit", app.saveState);
app.loadState = function () {
  try {
    var parser = Cc["@mozilla.org/xmlextras/domparser;1"]
      .createInstance(Ci.nsIDOMParser);
    var connectorString = idprefs.getCharPref("state.connector")
    var lastOpened = idprefs.getCharPref("state.lastopenedfile");
    if (lastOpened)
      lastOpened = idprefs.getComplexValue("state.lastopenedfile", Ci.nsILocalFile);
    else lastOpened = null;
    app.connector = new Connector();
    //logger.debug("Loading state from " + connectorString ); // ###
    app.connector.loadConf(parser.parseFromString(connectorString, "text/xml"));
    if (!app.template) app.openDefaultTemplate();
    app.changedConnector();
    app.set("canSave", idprefs.getBoolPref("state.cansave"));
    app.set("lastOpened", lastOpened);
    return true;
  } catch (err) {
    logger.debug(err);
    return false;
  }
};

app.newHl = function (doc, cb) {
  if (this.highlighter) {
    // highlighter doc has already been gc'd if we've changed pages
    if (doc === this.highlighter.doc) this.highlighter.destroy();
    this.highlighter = null;
  }
  var hl = new Highlighter(doc, cb);
  this.highlighter = hl;
  app.subscribe("selectedStep", function () {
    if (hl) {
      hl.destroy();
      hl = null;
    }
  });
  return this.highlighter;
};

// Set proxy to proxy from init, if available.
// Remove proxy if set.
app.toggleProxy = function (e) {
  if (!app.proxyButton) app.proxyButton = e.target;
  let prefs = Cc["@mozilla.org/preferences-service;1"]
    .getService(Ci.nsIPrefService).getBranch("network.proxy.");
  if (prefs.prefHasUserValue("type")) var type = prefs.getIntPref("type");
  // If proxy enabled (by us), disable and update button.
  if (app.proxied && type && type > 0) {
    prefs.setIntPref("type", "0");
    app.proxyButton.setAttribute("label", "Proxy?");
    app.set('proxied', false);
    return;
  }
  // Otherwise see if we can find an init task w/proxyip
  let ipRegex = /^([0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3})(?:\:([0-9]{1,5}))?$/;
  let initTasks = this.connector.findTasks('init');
  if (!(Array.isArray(initTasks) && (initTasks.length > 0))) return;
  let tests = initTasks[0].getTests();
  if (!(Array.isArray(tests) && (tests.length > 0))) return;
  let proxyip = this.connector.data.session.proxyip;
  if (!proxyip) proxyip = tests[0].getArg("proxyip");
  let result = ipRegex.exec(proxyip);
  if (!(Array.isArray(result) && (result.length > 1))) return;
  let ip = result[1];
  let port = result[2] || "80";
  if (ip && port) {
    prefs.setCharPref("http", ip);
    prefs.setIntPref("http_port", parseInt(port));
    prefs.setIntPref("type", 1);
    app.proxyButton.setAttribute("label", "Proxied.");
    app.set('proxied', true);
  }
  return;
};
app.subscribe('quit', function () {
  if (app.proxied) app.toggleProxy();
});
app.subscribe('connector', function () {
  if (app.proxied) {
    // It was on because CF toggled it on some previous connector.
    app.toggleProxy();
    // Since it was on because of a connector, we should try turning
    // it back on. It will stay off if this connector doesn't have one.
    app.toggleProxy();
  }
});

// Window loading
app.newStepWindow = function () {
  app.mainWindow.open('chrome://cfbuilder/content/step_browser.xul',
          'newStepWindow', 'chrome,width=240,height=512,resizable=yes').focus();
};
app.newScratchWindow = function () {
  app.mainWindow.open('chrome://cfbuilder/content/scratch.xul',
          'scratchWindow', 'chrome,width=420,height=600,resizable=yes').focus();
};
app.newMetaWindow = function () {
  app.mainWindow.openDialog('chrome://cfbuilder/content/meta_editor.xul',
          'metaEditor', 'chrome,resizable=yes').focus();
};
app.newTaskWindow = function () { app.mainWindow.open('chrome://cfbuilder/content/new_task.xul',
          'newTaskWindow', 'chrome,width=300,height=400,resizable=yes').focus();
};
app.newTestEditWindow = function () {
  app.mainWindow.open('chrome://cfbuilder/content/test_editor.xul',
          'testEditor', 'chrome,resizable=yes').focus();
};
app.newJsonEditWindow = function (obj, cb, windowName) {
  let win = app.mainWindow.open('chrome://cfbuilder/content/jsoneditor/index.html',
    windowName, 'chrome, width=800, height=600,resizable=yes');
  win.addEventListener('pageshow', function () {
    this.formatter.set(obj);
    this.main.formatterToEditor();
  }, false);
  win.addEventListener('close', function () {
    cb(this.formatter.get());
  }, false);
};
app.init = function () {};
