var EXPORTED_SYMBOLS = ["cqlEditor"];
Components.utils.import("resource://indexdata/util/xmlHelper.js");
Components.utils.import("resource://indexdata/ui/app.js");
Components.utils.import("resource://indexdata/ui/testEditor.js");
Components.utils.import("resource://indexdata/util/cql.js");
Components.utils.import("resource://indexdata/util/logging.js");

const NS = "http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul";
var logger = logging.getLogger();

var cqlEditor = {
  parser: new CQLParser(),
  doc: null,
  win: null,
  
  setXul: function (win) {
    this.win = win;
    this.doc = win.document;
  },

  onTextInput: function (txtBox) {
    try {
      this.parser.parse(txtBox.value, 'keyword', '=');
      this.doc.getElementById("cqlOutput").value = this.parser.toFQ("    ");
    } catch (e) {
      this.doc.getElementById("cqlOutput").value = e.message;
    }
  },

  populate: function() {
    try {
      var argVal = testEditor.getActiveTest().getArg('fullquery');
      this.parser.parseFromFQ(argVal, 'keyword', '=');
      this.doc.getElementById("cqlInput").value = this.parser.toString();
      this.doc.getElementById("cqlOutput").value = this.parser.toFQ("    ");
    } catch (e) {
      this.doc.getElementById("cqlOutput").value = e.message;
    }
  },

  confirm: function() {
    try {
      this.parser.parse(this.doc.getElementById("cqlInput").value, 
          'keyword', '=');
      logger.debug("setting the 'fullquery' to \n"+this.parser.toFQ());
      app.set('fullqueryEdited', this.parser.toFQ('', ''));
      this.win.close();
    } catch (e) {
      app.mainWindow.alert("Cannot convert CQL to fullquery: "+e.message);
    }

  }

};
