var EXPORTED_SYMBOLS = ["jsButton"];
Components.utils.import("resource://indexdata/runtime/core.js");
var jsButton = {
  btn: null,
  branch: null,
  init: function(btn) {
    this.btn = btn;
    this.branch = Components.classes["@mozilla.org/preferences-service;1"]
      .getService(Components.interfaces.nsIPrefService)
      .getBranch("javascript.enabled");
    if (Components.interfaces.nsIPrefBranch2)
      this.branch.QueryInterface(Components.interfaces.nsIPrefBranch2);
    this.branch.addObserver("", this, false);
    this.refresh();
  },
  refresh: function() {
    if (this.branch.getBoolPref("")) {
      this.btn.image="chrome://cfbuilder/content/icons/16x16/jsbutton.enabled.png";
      this.btn.setAttribute("tooltiptext", "JavaScript is enabled, click to toggle");
    } else {
      this.btn.image="chrome://cfbuilder/content/icons/16x16/jsbutton.disabled.png";
      this.btn.setAttribute("tooltiptext", "JavaScript is disabled, click to toggle");
    }
  },
  toggle: function() {
    this.branch.setBoolPref("", !this.branch.getBoolPref(""));
  },
  QueryInterface: function(aIID) {
    if (aIID.equals(Components.interfaces.nsIObserver) ||
        aIID.equals(Components.interfaces.nsISupportsWeakReference) ||
        aIID.equals(Components.interfaces.nsISupports))
      return this;
    throw Components.results.NS_NOINTERFACE;
  },
  observe: function(subject, topic, data) {
    this.refresh();
  },
};
