var EXPORTED_SYMBOLS = ["EventList"];

var EventList = function () {
  this.events = [];
};

EventList.prototype = {
  attachEvent: function (name, callback, userData) {
    if (typeof this.events[name] == 'undefined' ) {
      this.events[name] = [];
    // check if handler already registered
    } else {
      for (var i=0; i<this.events[name].length; i++) {
        if (callback === this.events[name][i].callback) {
          return false;
        }
      }
    } 
    this.events[name].push({
      'callback': callback,
      'userData': userData
    });
    return true;
  },

  detachEvent: function (name, callback) {
    if (typeof this.events[name] == 'undefined' )
      return false;    
    for (var i=0; i<this.events[name].length; i++) {
      if (callback === this.events[name][i].callback) {
      this.events[name].splice(i,1);
      return true;
      }
    }
    return false;
  },

  dispatchEvent: function (name, params) {
    if (typeof this.events[name] != 'undefined' ) {
      //copy the arguments
      var args = Array.prototype.slice.call(arguments);
      args.shift();
      for (var i=0; i<this.events[name].length; i++) {
        var handler = this.events[name][i];
        var handlerArgs = args.slice();
        handlerArgs.push(handler.userData);
        handler.callback.apply(null, handlerArgs);
      }
    }
  }
};
